<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ClearQuestionsSubjects extends Command
{
    protected $signature = 'tasheeh:clear-questions {--drop-attempts : Also delete quiz attempts and items}';
    protected $description = 'Clear options, questions, and subjects. Optional: also clear quiz attempts/items.';

    public function handle(): int
    {
        $dropAttempts = (bool)$this->option('drop-attempts');

        $this->warn('Clearing item bank…');
        Schema::disableForeignKeyConstraints();

        try {
            if ($dropAttempts) {
                $this->info('Dropping quiz attempts & items…');
                DB::table('quiz_attempt_items')->delete();
                DB::table('quiz_attempts')->delete();
            }

            $this->info('Deleting options…');
            DB::table('options')->delete();

            $this->info('Deleting questions…');
            DB::table('questions')->delete();

            if ($dropAttempts) {
                $this->info('Deleting subjects…');
                DB::table('subjects')->delete();
            } else {
                // Only delete subjects that are not referenced
                $this->info('Deleting subjects that have no referenced questions or attempts…');
                DB::statement("
                    DELETE s FROM subjects s
                    LEFT JOIN questions q ON q.subject_id = s.id
                    LEFT JOIN quiz_attempts a ON a.subject_id = s.id
                    WHERE q.id IS NULL AND a.id IS NULL
                ");
            }

            Schema::enableForeignKeyConstraints();
            $this->info('Done.');
            return self::SUCCESS;

        } catch (\Throwable $e) {
            Schema::enableForeignKeyConstraints();
            $this->error($e->getMessage());
            return self::FAILURE;
        }
    }
}
