<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\School;
use App\Models\QuizAttempt;
use App\Models\Question;
use App\Models\Exam;
use Carbon\Carbon;

class AdminController extends Controller
{
    public function index()
    {
        // Top stats
        $studentsCount  = User::where('role', '!=', 'admin')->count();
        $schoolsCount   = School::count();
        $attemptsCount  = QuizAttempt::count();
        $questionsCount = Question::count();

        // Attempts per day (last 7 days including today)
        $today = Carbon::today();
        $from  = (clone $today)->subDays(6);

        $raw = QuizAttempt::query()
            ->selectRaw('DATE(started_at) as d, COUNT(*) as c')
            ->whereBetween('started_at', [$from->startOfDay(), $today->endOfDay()])
            ->groupBy('d')
            ->orderBy('d')
            ->pluck('c', 'd'); // e.g. ['2025-08-18' => 5, ...]

        // Fill missing days with zeros
        $labels = [];
        $counts = [];
        for ($i = 0; $i < 7; $i++) {
            $day = (clone $from)->addDays($i);
            $key = $day->toDateString(); // 'Y-m-d'
            $labels[] = $day->format('D d'); // e.g. Mon 18
            $counts[] = (int) ($raw[$key] ?? 0);
        }

        // Latest 5 schools
        $latestSchools = School::orderByDesc('created_at')->limit(5)->get(['id','name','code','city','country','created_at']);

        $examsCount = Exam::count();
        return view('admin.dashboard', compact(
            'studentsCount','schoolsCount','attemptsCount','questionsCount','latestSchools',
            'labels','counts','examsCount'
        ));
    }
}
