<?php

namespace App\Http\Controllers;

use App\Models\Subject;
use App\Models\Exam;
use App\Models\QuizAttempt;
use App\Http\Controllers\StudentExamController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $subjects = Subject::where('is_active', true)->orderBy('name')->get();

        $attempts = QuizAttempt::with('subject')
            ->withCount('items')                    // ->items_count
            ->whereNull('exam_id')
            ->where('user_id', Auth::id())
            ->orderByDesc('started_at')
            ->limit(20)
            ->get();

        $activeExams = Exam::with(['subject','school'])
            ->where('is_active', true)
            ->where('school_id', $user->school_id)
            ->where(function($q) use ($user){
                $q->whereNull('grade')
                    ->orWhere('grade', (string)$user->educational_level);
            })
            ->orderByDesc('exam_date')
            ->orderByDesc('created_at')
            ->get();

        // Map existing exam attempts to decide Join vs Resume vs View
        $examAttempts = QuizAttempt::where('user_id', $user->id)
            ->whereNotNull('exam_id')
            ->get()
            ->keyBy('exam_id');
        return view('dashboard', compact('subjects', 'attempts' ,'examAttempts' ,'activeExams') ,);
    }
}
