<?php



namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LocaleController extends Controller
{
    public function switch(string $locale, Request $request)
    {
        if (!in_array($locale, ['en','ar'])) abort(404);

        $request->session()->put('locale', $locale);

        if (Auth::check()) {
            Auth::user()->update(['preferred_language' => $locale]);
        }

        // Go back to the same page
        return back();
    }
}
