<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\QuizAttempt;

class QuizController extends Controller
{
    public function show(Request $request, QuizAttempt $attempt)
    {
        // Only owner (or admin) may view
        if ($attempt->user_id !== $request->user()->id && $request->user()->role !== 'admin') {
            abort(403);
        }

        // Finished attempts go straight to results
        if ($attempt->finished_at) {
            return redirect()->route('attempts.results', $attempt->id);
        }

        // Render your existing quiz page
        return view('quiz.show', [
            'attempt'  => $attempt,
            'current'  => $attempt->total_items, // answered so far
            'max'      => $attempt->max_items,   // total to answer
        ]);
    }
}
