<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    protected $fillable = [
        'title',
        'subject_id',
        'question_language',
        'grade',
        'year',
        'school_id',
        'exam_date',
        'type',
        'num_questions',
        'is_active',
    ];

    protected $casts = [
        'exam_date' => 'date',
        'is_active' => 'boolean',
    ];

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function attempts()
    {
        return $this->hasMany(Attempt::class);
    }
}
