<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Option extends Model
{
    use HasFactory;

    protected $fillable = ['question_id','label','text_html','weight','is_correct'];

    protected $casts = [
        'weight'     => 'float',
        'is_correct' => 'boolean',
    ];

    public function question() { return $this->belongsTo(Question::class); }


    public function scopeOrdered($q) {
        return $q->orderByRaw("FIELD(label,'A','B','C','D')");
    }
}
