<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Question extends Model
{
    use HasFactory;

    protected $fillable = [
        'subject_id','question_language','grade','level','b','stem_html',
        'skills_text','outputs_text','external_id','is_active'
    ];

    protected $casts = [
        'level'     => 'integer',
        'b'         => 'float',
        'is_active' => 'boolean',
    ];

    public function subject() { return $this->belongsTo(Subject::class); }
    public function options() { return $this->hasMany(Option::class); }

    public function scopeActive($q) { return $q->where('is_active', true); }
    public function scopePool($q, $subjectId, $lang, $level) {
        return $q->active()
            ->where('subject_id', $subjectId)
            ->where('question_language', $lang)
            ->where('level', $level);
    }

    protected static function booted()
    {
        static::saving(function (Question $q) {
            if (is_null($q->b) && !is_null($q->level)) {
                // Map level 1..9 to Rasch b in [-2..+2], with level 5 -> 0
                $q->b = ($q->level - 5) / 2.0;
            }
        });
    }
}
