<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class QuizAttemptEvent extends Model
{
    use HasFactory;

    public $timestamps = false; // created_at only (from migration)
    protected $fillable = ['attempt_id','type','payload_json','created_at'];
    protected $casts = ['payload_json' => 'array', 'created_at' => 'datetime'];

    protected $table = 'quiz_attempt_events';

    public function attempt() { return $this->belongsTo(QuizAttempt::class, 'attempt_id'); }
}
