<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class QuizAttemptItem extends Model
{
    use HasFactory;

    protected $table = 'quiz_attempt_items';

    protected $fillable = [
        'attempt_id','question_id','level_presented','b_presented',
        'response_option_id','is_correct','position_index',
        'streak_after_correct','streak_after_wrong','target_level_next','answered_at'
        ,'exam_id',
    ];

    protected $casts = [
        'level_presented'     => 'integer',
        'b_presented'         => 'float',
        'is_correct'          => 'boolean',
        'position_index'      => 'integer',
        'streak_after_correct'=> 'integer',
        'streak_after_wrong'  => 'integer',
        'target_level_next'   => 'integer',
        'answered_at'         => 'datetime',
    ];

    public function attempt()       { return $this->belongsTo(QuizAttempt::class, 'attempt_id'); }
    public function question()      { return $this->belongsTo(Question::class); }
    public function responseOption(){ return $this->belongsTo(Option::class, 'response_option_id'); }
}
