<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class School extends Model
{
    // Allow mass assignment for these columns
    protected $fillable = [
        'name',
        'short_name',
        'code',
        'city',
        'country',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relations (optional but handy)

    public function students() { return $this->hasMany(\App\Models\User::class); }
}
