<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Subject extends Model
{
    use HasFactory;

    protected $fillable = ['code','name','is_active'];
    protected $casts = ['is_active' => 'boolean'];

    public function questions() { return $this->hasMany(Question::class); }
    public function attempts()  { return $this->hasMany(QuizAttempt::class); }
}
