<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('users', function (Blueprint $t) {
            $t->string('student_id')->unique()->after('id');
            $t->string('grade')->nullable()->after('password');                 // e.g., "Grade 5"
            $t->unsignedTinyInteger('educational_level')->nullable()->after('grade'); // 1..12 etc.
            $t->string('section')->nullable()->after('educational_level');      // e.g., "5B"
            $t->string('gender', 16)->nullable()->after('section');             // "M","F","Other"
            $t->string('nationality', 64)->nullable()->after('gender');
            $t->string('preferred_language', 8)->default('en')->after('nationality');

            // The default Laravel users table already has:
            // name, email (unique), email_verified_at, password, remember_token, timestamps
        });
    }

    public function down(): void {
        Schema::table('users', function (Blueprint $t) {
            $t->dropColumn([
                'student_id','grade','educational_level','section',
                'gender','nationality','preferred_language'
            ]);
        });
    }
};
