<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('options', function (Blueprint $t) {
            $t->id();
            $t->foreignId('question_id')->constrained('questions')->cascadeOnDelete();
            $t->string('label', 2); // 'A','B','C','D'
            $t->longText('text_html');
            $t->decimal('weight', 3, 2)->default(0); // 0..1 (partial credit supported)
            $t->boolean('is_correct')->default(false); // convenience; keep in sync with weight==1
            $t->timestamps();

            $t->unique(['question_id','label'], 'options_question_label_uq');
            $t->index(['question_id']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('options');
    }
};
