<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('questions', function (Blueprint $t) {
            $t->id();
            $t->foreignId('subject_id')->constrained('subjects');
            $t->string('question_language', 8)->index(); // 'en','ar'
            $t->string('grade')->nullable();             // e.g., "Grade 5"
            $t->unsignedTinyInteger('level')->index();   // 1..9
            $t->decimal('b', 5, 2)->nullable()->index(); // Rasch difficulty; if null, compute from level on import
            $t->longText('stem_html');                   // question text (HTML/text)
            $t->longText('skills_text')->nullable();     // free text
            $t->longText('outputs_text')->nullable();    // free text
            $t->string('external_id')->nullable()->unique(); // helps avoid duplicates on import
            $t->boolean('is_active')->default(true)->index();
            $t->timestamps();

            $t->index(['subject_id','question_language','level','is_active'], 'questions_pool_idx');
        });
    }

    public function down(): void {
        Schema::dropIfExists('questions');
    }
};
