<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('quiz_attempts', function (Blueprint $t) {
            $t->id();
            $t->foreignId('user_id')->constrained('users');
            $t->foreignId('subject_id')->constrained('subjects');
            $t->unsignedTinyInteger('max_items')->default(15); // 15,30,45,60
            $t->unsignedTinyInteger('start_level')->default(5);
            $t->decimal('start_theta', 6, 3)->default(0);

            $t->decimal('end_theta', 6, 3)->nullable();
            $t->decimal('se', 6, 3)->nullable();

            $t->unsignedSmallInteger('total_correct')->default(0);
            $t->unsignedSmallInteger('total_items')->default(0);

            $t->json('result_json')->nullable();
            $t->timestamp('started_at');
            $t->timestamp('finished_at')->nullable();
            $t->timestamps();

            $t->index(['user_id','subject_id','started_at'], 'attempts_user_subject_time_idx');
        });
    }

    public function down(): void {
        Schema::dropIfExists('quiz_attempts');
    }
};
