<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('quiz_attempt_events', function (Blueprint $t) {
            $t->id();
            $t->foreignId('attempt_id')->constrained('quiz_attempts')->cascadeOnDelete();
            $t->string('type', 32); // answer_submitted / level_up / level_down / complete
            $t->json('payload_json')->nullable();
            $t->timestamp('created_at')->useCurrent();
            $t->index(['attempt_id','type','created_at'], 'attempt_events_idx');
        });
    }

    public function down(): void {
        Schema::dropIfExists('quiz_attempt_events');
    }
};
