<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('quiz_attempt_items', function (Blueprint $t) {
            $t->id();
            $t->foreignId('attempt_id')->constrained('quiz_attempts')->cascadeOnDelete();
            $t->foreignId('question_id')->constrained('questions');
            $t->unsignedTinyInteger('level_presented');
            $t->decimal('b_presented', 5, 2)->nullable();

            $t->foreignId('response_option_id')->nullable()->constrained('options');
            $t->boolean('is_correct');
            $t->unsignedSmallInteger('position_index'); // 1..N

            // Log adaptive state after this item (for debugging/reporting)
            $t->unsignedTinyInteger('streak_after_correct')->default(0);
            $t->unsignedTinyInteger('streak_after_wrong')->default(0);
            $t->unsignedTinyInteger('target_level_next')->nullable();

            $t->timestamp('answered_at')->useCurrent();
            $t->timestamps();

            $t->index(['attempt_id','position_index'], 'attempt_items_position_idx');
            $t->index(['question_id']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('quiz_attempt_items');
    }
};
