<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('app_settings', function (Blueprint $t) {
            $t->id();
            $t->string('key')->unique();          // e.g., cat.streak_up_threshold
            $t->string('value')->nullable();      // store as string; cast in model
            $t->string('type', 16)->default('string'); // string|int|bool|json
            $t->string('group', 32)->nullable();  // e.g., 'cat'
            $t->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('app_settings');
    }
};
