<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('exams', function (Blueprint $table) {
            $table->id();

            $table->string('title');
            $table->foreignId('subject_id')->constrained()->cascadeOnDelete();
            $table->string('question_language', 2); // 'en'/'ar'
            $table->string('grade', 50)->nullable(); // e.g., "5" or "G5"
            $table->unsignedSmallInteger('year')->nullable(); // e.g., 2025

            $table->foreignId('school_id')->constrained()->cascadeOnDelete();
            $table->date('exam_date')->nullable();
            $table->string('type', 100)->nullable(); // e.g., "Midterm", "Final"
            $table->unsignedSmallInteger('num_questions')->default(15);

            $table->boolean('is_active')->default(true);

            $table->timestamps();

            $table->index(['school_id', 'grade', 'is_active']);
            $table->index(['subject_id', 'question_language']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('exams');
    }
};
