<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class AdminUserSeeder extends Seeder
{
    public function run(): void
    {
        User::updateOrCreate(
            ['username' => 'admin'],
            [
                'name'     => 'Administrator',
                'email'    => 'admin@example.com',   // must be unique & non-null
                'password' => Hash::make('admin'),
                'role'     => 'admin',
                // optional fields if your users table has them, keep null-safe:
                'student_id'        => 'admin',
                'preferred_language'=> 'en',
            ]
        );
    }
}
