<?php

return [
    'login.title' => 'Sign in',
    'login.subtitle' => 'Use email or Student ID',
    'login.login' => 'Email or Student ID',
    'login.password' => 'Password',
    'login.remember' => 'Remember me',
    'login.submit' => 'Sign in',
    'login.error' => 'These credentials do not match our records.',

    'dashboard.title' => 'Welcome to Tasheeh-CAT',
    'dashboard.logged_in' => 'You are logged in.',
    'dashboard.logout' => 'Log out',

    'footer.language' => 'Language',
    'footer.switch_to_en' => 'English',
    'footer.switch_to_ar' => 'العربية',


    'dashboard.start_quiz' => 'Start new quiz',
    'dashboard.recent_attempts' => 'Recent attempts',
    'dashboard.no_attempts' => 'No attempts yet',

    'table.subject' => 'Subject',
    'table.started_at' => 'Started at',
    'table.items' => 'Items',
    'table.result' => 'Result',
    'table.view' => 'View',

    'start_modal.title' => 'Start a new quiz',
    'start_modal.subject' => 'Subject',
    'start_modal.choose_subject' => 'Choose a subject',
    'start_modal.num_questions' => 'Number of questions',
    'start_modal.cancel' => 'Cancel',
    'start_modal.start' => 'Start quiz',

    'student.name' => 'Name',
    'student.id' => 'Student ID',
    'student.grade' => 'Grade',
    'student.level' => 'Level',
    'student.section' => 'Section',
    'student.language' => 'Language',

    'quiz.title' => 'Quiz Attempt',
    'quiz.max_items' => 'Max items',
    'quiz.start_level' => 'Start level',
    'quiz.started_at' => 'Started at',
    'quiz.placeholder' => 'Quiz UI will go here next.',

    'table.status' => 'Status',
    'status.in_progress' => 'In progress',
    'status.completed' => 'Completed',
    'action.resume' => 'Resume',
    'action.view_results' => 'View results',

    // ...existing
    'quiz' => [
        // ...
        'next'   => 'Next',
        'submit' => 'Submit quiz',
    ],


    'band' => [
        'below' => 'Below grade',
        'at'    => 'At grade',
        'above' => 'Above grade',
    ],

    'results' => [
        'title'                  => 'Quiz Attempt',
        'back'                   => 'Back',
        'band'                   => 'Band',
        'recommended_level'      => 'Recommended level',
        'se'                     => 'SE',
        'theta'                  => 'θ (theta)',
        'score'                  => 'Score',
        'difficulty_over_time'   => 'Difficulty over questions',
        'difficulty_level'       => 'Difficulty level',
        'correct'                => 'Correct',
        'wrong'                  => 'Wrong',
        'question_number'        => 'Question #',
        'difficulty_axis'        => 'Difficulty (level)',
    ],
    'login.subtitle' => 'Use email, Student ID, or Username',

    'admin' => [
        'dashboard' => [
            'title'        => 'Admin Dashboard',
            'student_area' => 'Student Area',
            'cards' => [
                'students'  => 'Students',
                'schools'   => 'Schools',
                'attempts'  => 'Attempts',
                'questions' => 'Questions',
                'exams' => 'Exams',
            ],
            'chart_title'    => 'Attempts (last 7 days)',
            'latest_schools' => 'Latest Schools',
            'show_all'       => 'Show all',
            'schools_table' => [
                'id'      => 'ID',
                'name'    => 'Name',
                'code'    => 'Code',
                'city'    => 'City',
                'country' => 'Country',
                'created' => 'Created',
            ],
        ],

        'schools' => [
            'title' => 'Schools',
            'back'  => 'Back to Admin',
            'empty' => 'No schools yet.',
            'filters' => [
                'title'        => 'Filters',
                'show_filters' => 'Show filters',
                'hide_filters' => 'Hide filters',
                'name'         => 'Name',
                'code'         => 'Code',
                'city'         => 'City',
                'filter'       => 'Filter',
                'reset'        => 'Reset',
            ],
            'table' => [
                'id'      => 'ID',
                'name'    => 'Name',
                'code'    => 'Code',
                'city'    => 'City',
                'students' => 'Students',
                'country' => 'Country',
                'active'  => 'Active',
            ],
            'actions' => [
                'actions'       => 'Actions',
                'add_new'       => 'Add school',
                'edit'          => 'Edit',
                'delete'        => 'Delete',
                'save'          => 'Save',
                'cancel'        => 'Cancel',
                'show_students' => 'Show students',
            ],
            'confirm_delete' => 'Delete this school? Students will be detached from it.',
            'loader' => [
                'loading' => 'Loading...',
                'failed'  => 'Failed to load school.',
            ],
            'form' => [
                'name'       => 'School name',
                'short_name' => 'Short name',
                'code'       => 'Code',
                'city'       => 'City',
                'country'    => 'Country',
                'active'     => 'Active',
            ],
            'flash' => [
                'created' => 'School created successfully.',
                'updated' => 'School updated successfully.',
                'deleted' => 'School deleted.',
            ],
        ],

        'students' => [
            'title' => 'Students',
            'back'  => 'Back to Schools',
            'empty' => 'No students found.',
            'filters' => [
                'title'        => 'Filters',
                'show_filters' => 'Show filters',
                'hide_filters' => 'Hide filters',
                'name'         => 'Name / Email / Student ID',
                'grade'        => 'Grade',
                'section'      => 'Section',
                'filter'       => 'Filter',
                'reset'        => 'Reset',
            ],
            'table' => [
                'id'      => 'ID',
                'name'    => 'Name',
                'email'   => 'Email',
                'grade'   => 'Grade',
                'level'   => 'Level',
                'section' => 'Section',
                'school'  => 'School',
            ],
            'actions' => [
                'actions'  => 'Actions',
                'add_new'  => 'Add student',
                'edit'     => 'Edit',
                'delete'   => 'Delete',
                'save'     => 'Save',
                'cancel'   => 'Cancel',
            ],
            'confirm_delete' => 'Delete this student?',
            'loader' => [
                'loading' => 'Loading...',
                'failed'  => 'Failed to load student.',
            ],
            'form' => [
                'name'        => 'Full name',
                'email'       => 'Email',
                'student_id'  => 'Student ID',
                'username'    => 'Username',
                'school'      => 'School',
                'select_school' => 'Select a school',
                'grade'       => 'Grade',
                'level'       => 'Level',
                'section'     => 'Section',
                'gender'      => 'Gender',
                'gender_placeholder' => 'e.g., Male / Female',
                'nationality' => 'Nationality',
                'language'    => 'Preferred language',
                'password'    => 'Password',
                'password_hint_create' => 'Leave blank to use Student ID or a random password',
                'password_hint_update' => 'Leave blank to keep current password',
                'password_confirmation' => 'Confirm password',
                'password_confirmation_hint' => 'Optional',
            ],
            'flash' => [
                'created' => 'Student created successfully.',
                'updated' => 'Student updated successfully.',
                'deleted' => 'Student deleted.',
            ],
        ],
        'questions' => [
            'title' => 'Questions',
            'back'  => 'Back to Admin',
            'empty' => 'No questions found.',
            'filters' => [
                'title'        => 'Filters',
                'show_filters' => 'Show filters',
                'hide_filters' => 'Hide filters',
                'search'  => 'Search text',
                'subject' => 'Subject',
                'grade'   => 'Grade',
                'level'   => 'Level',
                'all'     => 'All',
                'filter'  => 'Filter',
                'reset'   => 'Reset',
            ],
            'table' => [
                'id'       => 'ID',
                'subject'  => 'Subject',
                'grade'    => 'Grade',
                'level'    => 'Level',
                'lang'     => 'Lang',
                'question' => 'Question',
            ],
            'actions' => [
                'actions'  => 'Actions',
                'add_new'  => 'Add question',
                'edit'     => 'Edit',
                'delete'   => 'Delete',
                'save'     => 'Save',
                'cancel'   => 'Cancel',
            ],
            'confirm_delete' => 'Delete this question? This cannot be undone.',
            'loader' => [
                'loading' => 'Loading...',
                'failed'  => 'Failed to load question.',
            ],
            'form' => [
                'subject'       => 'Subject',
                'grade'         => 'Grade',
                'level'         => 'Level',
                'language'      => 'Language',
                'b'             => 'Rasch b (optional)',
                'active'        => 'Active',
                'stem_html'     => 'Question text (HTML)',
                'option'        => 'Option',
                'weight'        => 'Weight',
            ],
            'flash' => [
                'created' => 'Question created successfully.',
                'updated' => 'Question updated successfully.',
                'deleted' => 'Question deleted.',
            ],
            'import' => [
                'button'    => 'Import Excel',
                'success'   => 'Import complete: :sheets sheet(s), :rows rows, :subjects subject(s) created, :created question(s) created, :updated updated.',
                'failed'    => 'Failed to import the file. Please check format and try again.',
                'uploading' => 'Uploading...',
                'need_zip'      => 'PHP Zip extension is required to read .xlsx files. Please install/enable php-zip.',
                'failed_detail' => 'Failed to import the file: :msg',
            ],
        ],
        'exams' => [
            'title' => 'Exams',
            'back'  => 'Back to Admin',
            'empty' => 'No exams found.',
            'filters' => [
                'title'        => 'Filters',
                'show_filters' => 'Show filters',
                'hide_filters' => 'Hide filters',
                'title_label'  => 'Title',
                'subject'      => 'Subject',
                'school'       => 'School',
                'grade'        => 'Grade',
                'lang'         => 'Lang',
                'year'         => 'Year',
                'active'       => 'Active',
                'all'          => 'All',
                'filter'       => 'Filter',
                'reset'        => 'Reset',
            ],
            'table' => [
                'id'      => 'ID',
                'title'   => 'Title',
                'subject' => 'Subject',
                'school'  => 'School',
                'grade'   => 'Grade',
                'lang'    => 'Lang',
                'year'    => 'Year',
                'date'    => 'Date',
                'type'    => 'Type',
                'num_questions' => 'Questions',
                'active'  => 'Active',
            ],
            'actions' => [
                'actions'  => 'Actions',
                'add_new'  => 'Add exam',
                'edit'     => 'Edit',
                'delete'   => 'Delete',
                'save'     => 'Save',
                'cancel'   => 'Cancel',
            ],
            'confirm_delete' => 'Delete this exam?',
            'errors' => [
                'has_attempts' => 'This exam has attempts and cannot be deleted.',
            ],
            'loader' => [
                'loading' => 'Loading...',
                'failed'  => 'Failed to load exam.',
            ],
            'form' => [
                'title'          => 'Title',
                'subject'        => 'Subject',
                'language'       => 'Language',
                'grade'          => 'Grade',
                'year'           => 'Year',
                'school'         => 'School',
                'date'           => 'Exam date',
                'type'           => 'Type',
                'num_questions'  => 'Number of questions',
                'active'         => 'Active',
            ],
            'flash' => [
                'created' => 'Exam created successfully.',
                'updated' => 'Exam updated successfully.',
                'deleted' => 'Exam deleted.',
            ],
        ],
    ],


    'common' => [
        'yes' => 'Yes',
        'no'  => 'No',
    ],

    'dashboard' => [
        'title'            => 'Dashboard',
        'start_practice'   => 'Start a practice quiz',
        'select_subject'   => 'Subject',
        'num_questions'    => 'Number of questions',
        'student_summary'  => 'Student',
        'start_quiz'       => 'Start quiz',
        'no_active_exams'  => 'No active exams are currently available for you.',
    ],
    'profile' => [
        'grade' => 'Grade',
        'level' => 'Level',
    ],
    'student' => [
        'exams' => [
            'active_title' => 'Active Exams',
            'active_hint'  => 'Assigned by your school, one attempt only.',
            'join'         => 'Join',
            'resume'       => 'Resume',
            'view_result'  => 'View results',
            'submitted_status' => 'Submitted',
            'table' => [
                'title'   => 'Title',
                'subject' => 'Subject',
                'grade'   => 'Grade',
                'lang'    => 'Lang',
                'date'    => 'Date',
                'action'  => 'Action',
            ],
            'errors' => [
                'not_in_school'   => 'This exam is not assigned to your school.',
                'grade_mismatch'  => 'This exam is for a different grade.',
                'inactive'        => 'This exam is not active.',
            ],
            'submitted' => [
                'title'   => 'Your answers were submitted',
                'body'    => 'Thank you. Your school will review the results. You can leave this page.',
                'back'    => 'Back to dashboard',
                'summary' => 'Submission details',
                'fields'  => [
                    'exam'       => 'Exam',
                    'subject'    => 'Subject',
                    'date'       => 'Date',
                    'questions'  => 'Questions',
                    'attempt_id' => 'Attempt ID',
                    'time'       => 'Time',
                ],
            ],
        ],


        'practice' => [
            'title'        => 'Your practice attempts',
            'table' => [
                'started'  => 'Started at',
                'subject'  => 'Subject',
                'progress' => 'Progress',
                'status'   => 'Status',
                'action'   => 'Action',
            ],
            'finished'     => 'Finished',
            'in_progress'  => 'In progress',
            'resume'       => 'Resume',
            'view_result'  => 'View results',
            'empty'        => 'No practice attempts yet.',
        ],
    ],


];
