@extends('layouts.app')

@section('content')
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <h1 class="h5 m-0">{{ __('app.admin.dashboard.title') }}</h1>
                <a href="{{ route('dashboard') }}" class="btn btn-outline-secondary btn-sm">← {{ __('app.admin.dashboard.student_area') }}</a>
            </div>

            {{-- Top stat cards (clickable) --}}
            <div class="row g-3 mb-3">
                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1">{{ __('app.admin.dashboard.cards.students') }}</div>
                                <div class="fs-3 fw-semibold">{{ $studentsCount }}</div>
                            </div>
                            <span class="text-secondary fs-2">👩‍🎓</span>
                        </div>
                        <a href="#" class="stretched-link" aria-label="{{ __('app.admin.dashboard.cards.students') }}"></a>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1">{{ __('app.admin.dashboard.cards.schools') }}</div>
                                <div class="fs-3 fw-semibold">{{ $schoolsCount }}</div>
                            </div>
                            <span class="text-secondary fs-2">🏫</span>
                        </div>
                        <a href="{{ route('admin.schools.index') }}" class="stretched-link" aria-label="{{ __('app.admin.dashboard.cards.schools') }}"></a>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1">{{ __('app.admin.dashboard.cards.exams') }}</div>
                                <div class="fs-3 fw-semibold">{{ $examsCount }}</div>
                            </div>
                            <span class="text-secondary fs-2">🧪</span>
                        </div>
                        <a href="{{ route('admin.exams.index') }}" class="stretched-link" aria-label="{{ __('app.admin.dashboard.cards.exams') }}"></a>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1">{{ __('app.admin.dashboard.cards.attempts') }}</div>
                                <div class="fs-3 fw-semibold">{{ $attemptsCount }}</div>
                            </div>
                            <span class="text-secondary fs-2">✅</span>
                        </div>
                        <a href="#" class="stretched-link" aria-label="{{ __('app.admin.dashboard.cards.attempts') }}"></a>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1">{{ __('app.admin.dashboard.cards.questions') }}</div>
                                <div class="fs-3 fw-semibold">{{ $questionsCount }}</div>
                            </div>
                            <span class="text-secondary fs-2">❓</span>
                        </div>
                        <a href="{{ route('admin.questions.index') }}" class="stretched-link" aria-label="{{ __('app.admin.dashboard.cards.questions') }}"></a>
                    </div>
                </div>
            </div>

            {{-- Attempts vs Day (last 7 days) --}}
            <div class="card shadow-sm mb-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h2 class="h6 m-0">{{ __('app.admin.dashboard.chart_title') }}</h2>
                    </div>
                    <canvas id="attemptsChart" height="120"></canvas>
                </div>
            </div>

            {{-- Latest schools --}}
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h2 class="h6 m-0">{{ __('app.admin.dashboard.latest_schools') }}</h2>
                        <a class="btn btn-sm btn-outline-primary" href="{{ route('admin.schools.index') }}">{{ __('app.admin.dashboard.show_all') }}</a>
                    </div>

                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th>{{ __('app.admin.dashboard.schools_table.id') }}</th>
                                <th>{{ __('app.admin.dashboard.schools_table.name') }}</th>
                                <th>{{ __('app.admin.dashboard.schools_table.code') }}</th>
                                <th>{{ __('app.admin.dashboard.schools_table.city') }}</th>
                                <th>{{ __('app.admin.dashboard.schools_table.country') }}</th>
                                <th>{{ __('app.admin.dashboard.schools_table.created') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($latestSchools as $s)
                                <tr>
                                    <td>#{{ $s->id }}</td>
                                    <td>{{ $s->name }}</td>
                                    <td>{{ $s->code ?? '—' }}</td>
                                    <td>{{ $s->city ?? '—' }}</td>
                                    <td>{{ $s->country ?? '—' }}</td>
                                    <td>{{ $s->created_at?->format('Y-m-d') }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="6" class="text-muted">{{ __('app.admin.schools.empty') }}</td></tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>

    {{-- Chart.js --}}
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
    <script>
        (() => {
            const labels = @json($labels);
            const counts = @json($counts);

            const ctx = document.getElementById('attemptsChart').getContext('2d');
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels,
                    datasets: [{
                        label: @json(__('app.admin.dashboard.cards.attempts')),
                        data: counts,
                        backgroundColor: 'rgba(13,110,253,0.3)',
                        borderColor: '#0d6efd',
                        borderWidth: 1,
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: { grid: { display: false } },
                        y: { beginAtZero: true, ticks: { precision: 0 } }
                    },
                    plugins: { legend: { display: false } }
                }
            });
        })();
    </script>
@endsection
