@php $idSuf = ($mode ?? 'form'); @endphp
<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label">{{ __('app.admin.exams.form.title') }}</label>
        <input type="text" name="title" class="form-control" required>
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.exams.form.subject') }}</label>
        <select name="subject_id" class="form-select" required>
            @foreach($subjects as $s)
                <option value="{{ $s->id }}">{{ $s->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.exams.form.language') }}</label>
        <select name="question_language" class="form-select" required>
            <option value="en">EN</option>
            <option value="ar">AR</option>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.exams.form.grade') }}</label>
        <input type="text" name="grade" class="form-control" placeholder="e.g. 5">
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.exams.form.year') }}</label>
        <input type="number" name="year" class="form-control" min="2000" max="2100" placeholder="2025">
    </div>

    <div class="col-md-6">
        <label class="form-label">{{ __('app.admin.exams.form.school') }}</label>
        <select name="school_id" class="form-select" required>
            @foreach($schools as $sc)
                <option value="{{ $sc->id }}">{{ $sc->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.exams.form.date') }}</label>
        <input type="date" name="exam_date" class="form-control">
    </div>

    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.exams.form.type') }}</label>
        <input type="text" name="type" class="form-control" placeholder="Midterm / Final">
    </div>

    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.exams.form.num_questions') }}</label>
        <select name="num_questions" class="form-select" required>
            @foreach([15,30,45,60] as $n)
                <option value="{{ $n }}">{{ $n }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-12">
        <div class="form-check">
            <input type="hidden" name="is_active" value="0">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active_e_{{ $idSuf }}" value="1" checked>
            <label class="form-check-label" for="is_active_e_{{ $idSuf }}">{{ __('app.admin.exams.form.active') }}</label>
        </div>
    </div>
</div>
