@extends('layouts.app')

@section('content')
    @php
        $hasFilters = !empty(($filters['q'] ?? '')) ||
                      !empty(($filters['subject_id'] ?? '')) ||
                      strlen((string)($filters['grade'] ?? '')) ||
                      strlen((string)($filters['level'] ?? ''));
    @endphp

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0">{{ __('app.admin.questions.title') }}</h1>
                <div class="d-flex flex-wrap gap-2">
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-sm">← {{ __('app.admin.questions.back') }}</a>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalCreate">
                        {{ __('app.admin.questions.actions.add_new') }}
                    </button>
                    <button id="filterToggleBtn" class="btn btn-outline-primary btn-sm"
                            data-bs-toggle="collapse" data-bs-target="#filtersCollapse" aria-expanded="{{ $hasFilters ? 'true' : 'false' }}">
                        {{ $hasFilters ? __('app.admin.questions.filters.hide_filters') : __('app.admin.questions.filters.show_filters') }}
                    </button>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">{{ $errors->first() }}</div>
            @endif

            @if(session('status'))
                <div class="alert alert-success">{{ session('status') }}</div>
            @endif

            {{-- Filters + Import (collapsible) --}}
            <div class="collapse {{ $hasFilters ? 'show' : '' }}" id="filtersCollapse">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <span class="fw-semibold">{{ __('app.admin.questions.filters.title') }}</span>

                        {{-- Import from Excel --}}
                        <form id="excelImportForm" class="d-flex align-items-center gap-2 m-0" method="POST"
                              action="{{ route('admin.questions.import') }}" enctype="multipart/form-data">
                            @csrf
                            <input id="excelPicker" type="file" name="file" accept=".xlsx,.xls,.csv" class="d-none">
                            <button type="button" id="excelBtn" class="btn btn-outline-success btn-sm">
                                {{ __('app.admin.questions.import.button') }}
                            </button>
                        </form>
                    </div>

                    <div class="card-body">
                        <form method="GET" action="{{ route('admin.questions.index') }}" class="row g-2 align-items-end">
                            <div class="col-12 col-md-4">
                                <label class="form-label">{{ __('app.admin.questions.filters.search') }}</label>
                                <input type="text"
                                       name="q"
                                       value="{{ $filters['q'] ?? '' }}"
                                       class="form-control"
                                       placeholder="{{ __('app.admin.questions.filters.search') }}">
                            </div>

                            <div class="col-6 col-md-2">
                                <label class="form-label">{{ __('app.admin.questions.filters.subject') }}</label>
                                <select name="subject_id" class="form-select">
                                    <option value="">{{ __('app.admin.questions.filters.all') }}</option>
                                    @foreach($subjects as $s)
                                        <option value="{{ $s->id }}" @selected(($filters['subject_id'] ?? '') == $s->id)>{{ $s->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-6 col-md-2">
                                <label class="form-label">{{ __('app.admin.questions.filters.grade') }}</label>
                                <select name="grade" class="form-select">
                                    <option value="">{{ __('app.admin.questions.filters.all') }}</option>
                                    @foreach($grades as $g)
                                        <option value="{{ $g }}" @selected(($filters['grade'] ?? '') == $g)>{{ $g }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-6 col-md-2">
                                <label class="form-label">{{ __('app.admin.questions.filters.level') }}</label>
                                <select name="level" class="form-select">
                                    <option value="">{{ __('app.admin.questions.filters.all') }}</option>
                                    @foreach($levels as $lvl)
                                        <option value="{{ $lvl }}" @selected(($filters['level'] ?? '') == $lvl)>{{ $lvl }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-6 col-md-2 d-flex gap-2">
                                <button type="submit" class="btn btn-primary w-100">{{ __('app.admin.questions.filters.filter') }}</button>
                                <a href="{{ route('admin.questions.index') }}" class="btn btn-outline-secondary">{{ __('app.admin.questions.filters.reset') }}</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- List --}}
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th style="width:70px;">{{ __('app.admin.questions.table.id') }}</th>
                                <th style="width:200px;">{{ __('app.admin.questions.table.subject') }}</th>
                                <th style="width:90px;">{{ __('app.admin.questions.table.grade') }}</th>
                                <th style="width:90px;">{{ __('app.admin.questions.table.level') }}</th>
                                <th style="width:90px;">{{ __('app.admin.questions.table.lang') }}</th>
                                <th>{{ __('app.admin.questions.table.question') }}</th>
                                <th style="width:160px;" class="text-end">{{ __('app.admin.questions.actions.actions') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse ($questions as $q)
                                <tr>
                                    <td>#{{ $q->id }}</td>
                                    <td>{{ $q->subject?->name ?? $q->subject_id }}</td>
                                    <td>{{ $q->grade ?? '—' }}</td>
                                    <td>{{ $q->level }}</td>
                                    <td>{{ strtoupper($q->question_language) }}</td>
                                    <td><div class="q-stem clamp-3">{!! $q->stem_html !!}</div></td>
                                    <td class="text-end">
                                        <button class="btn btn-sm btn-outline-primary js-edit" data-id="{{ $q->id }}" data-bs-toggle="modal" data-bs-target="#modalEdit">
                                            {{ __('app.admin.questions.actions.edit') }}
                                        </button>
                                        <form action="{{ route('admin.questions.destroy', $q->id) }}" method="POST" class="d-inline js-delete">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                {{ __('app.admin.questions.actions.delete') }}
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr><td colspan="7" class="text-muted">{{ __('app.admin.questions.empty') }}</td></tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $questions->onEachSide(1)->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Create Modal --}}
    <div class="modal fade" id="modalCreate" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form method="POST" action="{{ route('admin.questions.store') }}">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('app.admin.questions.actions.add_new') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('app.admin.questions.actions.cancel') }}"></button>
                    </div>
                    <div class="modal-body">
                        @include('admin.questions.partials.form', ['mode' => 'create'])
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('app.admin.questions.actions.cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('app.admin.questions.actions.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Edit Modal --}}
    <div class="modal fade" id="modalEdit" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form id="editForm" method="POST" action="#">
                    @csrf @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('app.admin.questions.actions.edit') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('app.admin.questions.actions.cancel') }}"></button>
                    </div>
                    <div class="modal-body">
                        <div id="editLoader" class="text-center my-5">
                            <div class="spinner-border" role="status"></div>
                            <div class="mt-2">{{ __('app.admin.questions.loader.loading') }}</div>
                        </div>
                        <div id="editFields" class="d-none">
                            @include('admin.questions.partials.form', ['mode' => 'edit'])
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('app.admin.questions.actions.cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('app.admin.questions.actions.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Styles --}}
    <style>
        .q-stem { max-width:100%; overflow:hidden; }
        .clamp-3 { display:-webkit-box; -webkit-line-clamp:3; -webkit-box-orient:vertical; }
        .q-stem, .q-stem * { font-size:.95rem !important; line-height:1.5; }
    </style>

    {{-- Scripts --}}
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Delete confirm
            document.querySelectorAll('.js-delete').forEach(form => {
                form.addEventListener('submit', (e) => {
                    if (!confirm(@json(__('app.admin.questions.confirm_delete')))) {
                        e.preventDefault();
                    }
                });
            });

            // Edit loader + fetch
            const editForm   = document.getElementById('editForm');
            const editLoader = document.getElementById('editLoader');
            const editFields = document.getElementById('editFields');

            document.querySelectorAll('.js-edit').forEach(btn => {
                btn.addEventListener('click', async () => {
                    const id = btn.dataset.id;
                    // reset UI
                    editLoader.classList.remove('d-none');
                    editFields.classList.add('d-none');
                    // set action
                    editForm.action = @json(route('admin.questions.update', ':id')).replace(':id', id);

                    // fetch data
                    try {
                        const res = await fetch(@json(route('admin.questions.show', ':id')).replace(':id', id), { headers: { 'Accept':'application/json' }});
                        const data = await res.json();

                        // Fill fields
                        fillQuestionForm(editFields, data);

                        editLoader.classList.add('d-none');
                        editFields.classList.remove('d-none');
                    } catch (e) {
                        console.error(e);
                        alert(@json(__('app.admin.questions.loader.failed')));
                    }
                });
            });

            function fillQuestionForm(container, data) {
                container.querySelector('[name="subject_id"]').value = data.subject_id ?? '';
                container.querySelector('[name="grade"]').value       = data.grade ?? '';
                container.querySelector('[name="level"]').value       = data.level ?? '';
                container.querySelector('[name="question_language"]').value = data.question_language ?? 'en';
                container.querySelector('[name="b"]').value           = (data.b ?? '') === null ? '' : data.b;
                container.querySelector('[name="is_active"]').checked = !!data.is_active;
                container.querySelector('[name="stem_html"]').value   = data.stem_html ?? '';

                const byLabel = {};
                (data.options || []).forEach(o => byLabel[o.label] = o);
                ['A','B','C','D'].forEach(L => {
                    const o = byLabel[L] || {};
                    container.querySelector(`[name="options[${L}][text_html]"]`).value = o.text_html ?? '';
                    container.querySelector(`[name="options[${L}][weight]"]`).value    = (o.weight ?? 0);
                });
            }

            // Excel picker auto-submit
            const picker = document.getElementById('excelPicker');
            const btn    = document.getElementById('excelBtn');
            const form   = document.getElementById('excelImportForm');
            if (btn && picker && form) {
                btn.addEventListener('click', () => picker.click());
                picker.addEventListener('change', () => {
                    if (picker.files.length) {
                        btn.disabled = true;
                        btn.textContent = @json(__('app.admin.questions.import.uploading'));
                        form.submit();
                    }
                });
            }

            // Toggle button label for filters
            const filterToggleBtn = document.getElementById('filterToggleBtn');
            const filtersCollapse = document.getElementById('filtersCollapse');
            const LABEL_SHOW = @json(__('app.admin.questions.filters.show_filters'));
            const LABEL_HIDE = @json(__('app.admin.questions.filters.hide_filters'));

            filtersCollapse.addEventListener('shown.bs.collapse', () => { filterToggleBtn.textContent = LABEL_HIDE; });
            filtersCollapse.addEventListener('hidden.bs.collapse', () => { filterToggleBtn.textContent = LABEL_SHOW; });
        });
    </script>
@endsection
