{{-- resources/views/admin/questions/partials/form.blade.php --}}
@php
    $subjects = $subjects ?? \App\Models\Subject::orderBy('name')->get(['id','name']);
    $levels   = $levels   ?? range(1,9);
@endphp

<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label">{{ __('app.admin.questions.form.subject') }}</label>
        <select name="subject_id" class="form-select" required>
            <option value="">{{ __('app.admin.questions.filters.all') }}</option>
            @foreach($subjects as $s)
                <option value="{{ $s->id }}">{{ $s->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.questions.form.grade') }}</label>
        <input type="text" name="grade" class="form-control" placeholder="e.g. 5">
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.questions.form.level') }}</label>
        <select name="level" class="form-select" required>
            @foreach($levels as $lvl)
                <option value="{{ $lvl }}">L{{ $lvl }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.questions.form.language') }}</label>
        <select name="question_language" class="form-select" required>
            <option value="en">EN</option>
            <option value="ar">AR</option>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label">{{ __('app.admin.questions.form.b') }}</label>
        <input type="number" step="0.01" name="b" class="form-control" placeholder="e.g. 0.0">
    </div>

    @php $idSuf = ($mode ?? 'form'); @endphp
    <div class="col-md-3 d-flex align-items-end">
        <div class="form-check">
            <input type="hidden" name="is_active" value="0">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active_q_{{ $idSuf }}" value="1" checked>
            <label class="form-check-label" for="is_active_q_{{ $idSuf }}">{{ __('app.admin.questions.form.active') }}</label>
        </div>
    </div>


    <div class="col-12">
        <label class="form-label">{{ __('app.admin.questions.form.stem_html') }}</label>
        <textarea name="stem_html" class="form-control" rows="5" required></textarea>
    </div>

    <div class="col-12">
        <div class="row g-3">
            @foreach (['A','B','C','D'] as $L)
                <div class="col-12 col-md-6">
                    <div class="border rounded p-3 h-100">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <strong>{{ __('app.admin.questions.form.option') }} {{ $L }}</strong>
                            <div class="d-flex align-items-center gap-2">
                                <label class="small text-muted m-0">{{ __('app.admin.questions.form.weight') }}</label>
                                <input type="number" step="0.01" min="0" max="1" name="options[{{ $L }}][weight]" class="form-control form-control-sm" style="width:90px" value="{{ $L==='A' ? 1 : 0 }}">
                            </div>
                        </div>
                        <textarea name="options[{{ $L }}][text_html]" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
