@extends('layouts.app')

@section('content')
    @php
        $hasFilters = ($filters['name'] ?? '') !== '' || ($filters['code'] ?? '') !== '' || ($filters['city'] ?? '') !== '';
    @endphp

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0">{{ __('app.admin.schools.title') }}</h1>
                <div class="d-flex flex-wrap gap-2">
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-sm">← {{ __('app.admin.schools.back') }}</a>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalCreate">
                        {{ __('app.admin.schools.actions.add_new') }}
                    </button>
                    <button id="filterToggleBtn" class="btn btn-outline-primary btn-sm"
                            data-bs-toggle="collapse" data-bs-target="#filtersCollapse" aria-expanded="{{ $hasFilters ? 'true' : 'false' }}">
                        {{ $hasFilters ? __('app.admin.schools.filters.hide_filters') : __('app.admin.schools.filters.show_filters') }}
                    </button>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">{{ $errors->first() }}</div>
            @endif
            @if (session('status'))
                <div class="alert alert-success">{{ session('status') }}</div>
            @endif

            {{-- Filters --}}
            <div class="collapse {{ $hasFilters ? 'show' : '' }}" id="filtersCollapse">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-white fw-semibold">{{ __('app.admin.schools.filters.title') }}</div>
                    <div class="card-body">
                        <form method="GET" action="{{ route('admin.schools.index') }}" class="row g-2 align-items-end">
                            <div class="col-12 col-md-4">
                                <label class="form-label">{{ __('app.admin.schools.filters.name') }}</label>
                                <input type="text" name="name" class="form-control" value="{{ $filters['name'] ?? '' }}" placeholder="{{ __('app.admin.schools.filters.name') }}">
                            </div>
                            <div class="col-6 col-md-4">
                                <label class="form-label">{{ __('app.admin.schools.filters.code') }}</label>
                                <input type="text" name="code" class="form-control" value="{{ $filters['code'] ?? '' }}" placeholder="{{ __('app.admin.schools.filters.code') }}">
                            </div>
                            <div class="col-6 col-md-4">
                                <label class="form-label">{{ __('app.admin.schools.filters.city') }}</label>
                                <input type="text" name="city" class="form-control" value="{{ $filters['city'] ?? '' }}" placeholder="{{ __('app.admin.schools.filters.city') }}">
                            </div>
                            <div class="col-12 d-flex gap-2">
                                <button type="submit" class="btn btn-primary">{{ __('app.admin.schools.filters.filter') }}</button>
                                <a href="{{ route('admin.schools.index') }}" class="btn btn-outline-secondary">{{ __('app.admin.schools.filters.reset') }}</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- List --}}
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th style="width:80px;">{{ __('app.admin.schools.table.id') }}</th>
                                <th>{{ __('app.admin.schools.table.name') }}</th>
                                <th style="width:140px;">{{ __('app.admin.schools.table.code') }}</th>
                                <th style="width:180px;">{{ __('app.admin.schools.table.city') }}</th>
                                <th style="width:180px;">{{ __('app.admin.schools.table.country') }}</th>
                                <th style="width:120px;">{{ __('app.admin.schools.table.students') }}</th>
                                <th style="width:120px;">{{ __('app.admin.schools.table.active') }}</th>
                                <th style="width:220px;" class="text-end">{{ __('app.admin.schools.actions.actions') }}</th>

                            </tr>
                            </thead>
                            <tbody>
                            @forelse ($schools as $s)
                                <tr>
                                    <td>#{{ $s->id }}</td>
                                    <td>{{ $s->name }}</td>
                                    <td>{{ $s->code ?? '—' }}</td>
                                    <td>{{ $s->city ?? '—' }}</td>
                                    <td>{{ $s->country ?? '—' }}</td>
                                    <td class="text-center">
                                        <a href="{{ route('admin.students.index', ['school_id' => $s->id]) }}" class="btn btn-link btn-sm p-0">
                                            {{ $s->students_count ?? 0 }}
                                        </a>
                                    </td>
                                    <td>
                                        @if($s->is_active)
                                            <span class="badge text-bg-success">{{ __('app.common.yes') }}</span>
                                        @else
                                            <span class="badge text-bg-secondary">{{ __('app.common.no') }}</span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <a class="btn btn-sm btn-outline-dark me-1" href="{{ route('admin.students.index', ['school_id' => $s->id]) }}">
                                            {{ __('app.admin.schools.actions.show_students') }}
                                        </a>

                                        <button class="btn btn-sm btn-outline-primary p-1 js-edit me-1"
                                                data-id="{{ $s->id }}"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalEdit"
                                                data-bs-toggle1="tooltip" title="{{ __('app.admin.schools.actions.edit') }}"
                                                aria-label="{{ __('app.admin.schools.actions.edit') }}">
                                            <i class="bi bi-pencil-square"></i><span class="visually-hidden">{{ __('app.admin.schools.actions.edit') }}</span>
                                        </button>

                                        <form action="{{ route('admin.schools.destroy', $s->id) }}" method="POST" class="d-inline js-delete">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger p-1"
                                                    data-bs-toggle="tooltip" title="{{ __('app.admin.schools.actions.delete') }}"
                                                    aria-label="{{ __('app.admin.schools.actions.delete') }}">
                                                <i class="bi bi-trash"></i><span class="visually-hidden">{{ __('app.admin.schools.actions.delete') }}</span>
                                            </button>
                                        </form>
                                    </td>

                                </tr>
                            @empty
                                <tr><td colspan="7" class="text-muted">{{ __('app.admin.schools.empty') }}</td></tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $schools->onEachSide(1)->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Create Modal --}}
    <div class="modal fade" id="modalCreate" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form method="POST" action="{{ route('admin.schools.store') }}">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('app.admin.schools.actions.add_new') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('app.admin.schools.actions.cancel') }}"></button>
                    </div>
                    <div class="modal-body">
                        @include('admin.schools.partials.form', ['mode' => 'create'])
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('app.admin.schools.actions.cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('app.admin.schools.actions.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Edit Modal --}}
    <div class="modal fade" id="modalEdit" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form id="editForm" method="POST" action="#">
                    @csrf @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('app.admin.schools.actions.edit') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('app.admin.schools.actions.cancel') }}"></button>
                    </div>
                    <div class="modal-body">
                        <div id="editLoader" class="text-center my-5">
                            <div class="spinner-border" role="status"></div>
                            <div class="mt-2">{{ __('app.admin.schools.loader.loading') }}</div>
                        </div>
                        <div id="editFields" class="d-none">
                            @include('admin.schools.partials.form', ['mode' => 'edit'])
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('app.admin.schools.actions.cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('app.admin.schools.actions.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Delete confirm
            document.querySelectorAll('.js-delete').forEach(form => {
                form.addEventListener('submit', (e) => {
                    if (!confirm(@json(__('app.admin.schools.confirm_delete')))) e.preventDefault();
                });
            });

            // Edit loader/fill
            const editForm   = document.getElementById('editForm');
            const editLoader = document.getElementById('editLoader');
            const editFields = document.getElementById('editFields');

            document.querySelectorAll('.js-edit').forEach(btn => {
                btn.addEventListener('click', async () => {
                    const id = btn.dataset.id;
                    editLoader.classList.remove('d-none');
                    editFields.classList.add('d-none');

                    editForm.action = @json(route('admin.schools.update', ':id')).replace(':id', id);

                    try {
                        const res = await fetch(@json(route('admin.schools.show', ':id')).replace(':id', id), { headers: { 'Accept':'application/json' }});
                        const data = await res.json();
                        fillSchoolForm(editFields, data);
                        editLoader.classList.add('d-none');
                        editFields.classList.remove('d-none');
                    } catch (e) {
                        alert(@json(__('app.admin.schools.loader.failed')));
                    }
                });
            });

            function fillSchoolForm(container, data) {
                container.querySelector('[name="name"]').value       = data.name ?? '';
                container.querySelector('[name="short_name"]').value = data.short_name ?? '';
                container.querySelector('[name="code"]').value       = data.code ?? '';
                container.querySelector('[name="city"]').value       = data.city ?? '';
                container.querySelector('[name="country"]').value    = data.country ?? '';
                container.querySelector('[name="is_active"]').checked= !!data.is_active;
            }

            // Toggle filters label
            const filterToggleBtn = document.getElementById('filterToggleBtn');
            const filtersCollapse = document.getElementById('filtersCollapse');
            const LABEL_SHOW = @json(__('app.admin.schools.filters.show_filters'));
            const LABEL_HIDE = @json(__('app.admin.schools.filters.hide_filters'));
            filtersCollapse.addEventListener('shown.bs.collapse',  () => filterToggleBtn.textContent = LABEL_HIDE);
            filtersCollapse.addEventListener('hidden.bs.collapse', () => filterToggleBtn.textContent = LABEL_SHOW);
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Initialize Bootstrap tooltips
            const triggers = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"],[data-bs-toggle1="tooltip"]'));
            triggers.forEach(el => new bootstrap.Tooltip(el));
        });
    </script>
@endsection
