@extends('layouts.app')

@section('content')
    @php
        $hasFilters = ($filters['name'] ?? '') !== '' || ($filters['grade'] ?? '') !== '' || ($filters['section'] ?? '') !== '';
    @endphp

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">

            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0">{{ __('app.admin.students.title') }}</h1>
                <div class="d-flex flex-wrap gap-2">
                    <a href="{{ route('admin.schools.index') }}" class="btn btn-outline-secondary btn-sm">← {{ __('app.admin.students.back') }}</a>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalCreate">
                        {{ __('app.admin.students.actions.add_new') }}
                    </button>
                    <button id="filterToggleBtn" class="btn btn-outline-primary btn-sm"
                            data-bs-toggle="collapse" data-bs-target="#filtersCollapse" aria-expanded="{{ $hasFilters ? 'true' : 'false' }}">
                        {{ $hasFilters ? __('app.admin.students.filters.hide_filters') : __('app.admin.students.filters.show_filters') }}
                    </button>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">{{ $errors->first() }}</div>
            @endif
            @if (session('status'))
                <div class="alert alert-success">{{ session('status') }}</div>
            @endif

            {{-- Filters --}}
            <div class="collapse {{ $hasFilters ? 'show' : '' }}" id="filtersCollapse">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-white fw-semibold">{{ __('app.admin.students.filters.title') }}</div>
                    <div class="card-body">
                        <form method="GET" action="{{ route('admin.students.index') }}" class="row g-2 align-items-end">
                            <div class="col-12 col-md-4">
                                <label class="form-label">{{ __('app.admin.students.filters.name') }}</label>
                                <input type="text" name="name" class="form-control" value="{{ $filters['name'] ?? '' }}" placeholder="{{ __('app.admin.students.filters.name') }}">
                            </div>
                            <div class="col-6 col-md-4">
                                <label class="form-label">{{ __('app.admin.students.filters.grade') }}</label>
                                <input type="text" name="grade" class="form-control" value="{{ $filters['grade'] ?? '' }}" placeholder="{{ __('app.admin.students.filters.grade') }}">
                            </div>
                            <div class="col-6 col-md-4">
                                <label class="form-label">{{ __('app.admin.students.filters.section') }}</label>
                                <input type="text" name="section" class="form-control" value="{{ $filters['section'] ?? '' }}" placeholder="{{ __('app.admin.students.filters.section') }}">
                            </div>
                            <div class="col-12 d-flex gap-2">
                                <button type="submit" class="btn btn-primary">{{ __('app.admin.students.filters.filter') }}</button>
                                <a href="{{ route('admin.students.index') }}" class="btn btn-outline-secondary">{{ __('app.admin.students.filters.reset') }}</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- List --}}
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th style="width:80px;">{{ __('app.admin.students.table.id') }}</th>
                                <th>{{ __('app.admin.students.table.name') }}</th>
                                <th>{{ __('app.admin.students.table.email') }}</th>
                                <th style="width:100px;">{{ __('app.admin.students.table.grade') }}</th>
                                <th style="width:100px;">{{ __('app.admin.students.table.level') }}</th>
                                <th style="width:120px;">{{ __('app.admin.students.table.section') }}</th>
                                <th style="width:220px;">{{ __('app.admin.students.table.school') }}</th>
                                <th style="width:110px;" class="text-end">{{ __('app.admin.students.actions.actions') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse ($students as $u)
                                <tr>
                                    <td>#{{ $u->id }}</td>
                                    <td>{{ $u->name }}</td>
                                    <td>{{ $u->email ?? '—' }}</td>
                                    <td>{{ $u->grade ?? '—' }}</td>
                                    <td>{{ $u->level ?? '—' }}</td>
                                    <td>{{ $u->section ?? '—' }}</td>
                                    <td>{{ $u->school?->name ?? '—' }}</td>
                                    <td class="text-end">
                                        <button class="btn btn-sm btn-outline-primary p-1 js-edit me-1"
                                                data-id="{{ $u->id }}"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalEdit"
                                                data-bs-toggle1="tooltip" title="{{ __('app.admin.students.actions.edit') }}"
                                                aria-label="{{ __('app.admin.students.actions.edit') }}">
                                            <i class="bi bi-pencil-square"></i><span class="visually-hidden">{{ __('app.admin.students.actions.edit') }}</span>
                                        </button>

                                        <form action="{{ route('admin.students.destroy', $u->id) }}" method="POST" class="d-inline js-delete">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger p-1"
                                                    data-bs-toggle="tooltip" title="{{ __('app.admin.students.actions.delete') }}"
                                                    aria-label="{{ __('app.admin.students.actions.delete') }}">
                                                <i class="bi bi-trash"></i><span class="visually-hidden">{{ __('app.admin.students.actions.delete') }}</span>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr><td colspan="8" class="text-muted">{{ __('app.admin.students.empty') }}</td></tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $students->onEachSide(1)->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Create Modal --}}
    <div class="modal fade" id="modalCreate" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form method="POST" action="{{ route('admin.students.store') }}">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('app.admin.students.actions.add_new') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('app.admin.students.actions.cancel') }}"></button>
                    </div>
                    <div class="modal-body">
                        @include('admin.students.partials.form', ['mode' => 'create', 'schools' => $schools])
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('app.admin.students.actions.cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('app.admin.students.actions.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Edit Modal --}}
    <div class="modal fade" id="modalEdit" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form id="editForm" method="POST" action="#">
                    @csrf @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('app.admin.students.actions.edit') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('app.admin.students.actions.cancel') }}"></button>
                    </div>
                    <div class="modal-body">
                        <div id="editLoader" class="text-center my-5">
                            <div class="spinner-border" role="status"></div>
                            <div class="mt-2">{{ __('app.admin.students.loader.loading') }}</div>
                        </div>
                        <div id="editFields" class="d-none">
                            @include('admin.students.partials.form', ['mode' => 'edit', 'schools' => $schools])
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('app.admin.students.actions.cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('app.admin.students.actions.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Tooltips
            const triggers = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"],[data-bs-toggle1="tooltip"]'));
            triggers.forEach(el => new bootstrap.Tooltip(el));

            // Delete confirm
            document.querySelectorAll('.js-delete').forEach(form => {
                form.addEventListener('submit', (e) => {
                    if (!confirm(@json(__('app.admin.students.confirm_delete')))) e.preventDefault();
                });
            });

            // Edit loader + fetch
            const editForm   = document.getElementById('editForm');
            const editLoader = document.getElementById('editLoader');
            const editFields = document.getElementById('editFields');

            document.querySelectorAll('.js-edit').forEach(btn => {
                btn.addEventListener('click', async () => {
                    const id = btn.dataset.id;
                    editLoader.classList.remove('d-none');
                    editFields.classList.add('d-none');

                    editForm.action = @json(route('admin.students.update', ':id')).replace(':id', id);

                    try {
                        const res = await fetch(@json(route('admin.students.show', ':id')).replace(':id', id), { headers: { 'Accept':'application/json' }});
                        const data = await res.json();
                        fillStudentForm(editFields, data);
                        editLoader.classList.add('d-none');
                        editFields.classList.remove('d-none');
                    } catch (e) {
                        alert(@json(__('app.admin.students.loader.failed')));
                    }
                });
            });

            function fillStudentForm(container, data) {
                container.querySelector('[name="name"]').value        = data.name ?? '';
                container.querySelector('[name="email"]').value       = data.email ?? '';
                container.querySelector('[name="student_id"]').value  = data.student_id ?? '';
                container.querySelector('[name="username"]').value    = data.username ?? '';
                container.querySelector('[name="grade"]').value       = data.grade ?? '';
                container.querySelector('[name="level"]').value       = data.level ?? '';
                container.querySelector('[name="section"]').value     = data.section ?? '';
                container.querySelector('[name="gender"]').value      = data.gender ?? '';
                container.querySelector('[name="nationality"]').value = data.nationality ?? '';
                container.querySelector('[name="preferred_language"]').value = data.preferred_language ?? 'en';
                container.querySelector('[name="school_id"]').value   = data.school_id ?? '';
                // passwords left blank = unchanged
                container.querySelector('[name="password"]').value = '';
                container.querySelector('[name="password_confirmation"]').value = '';
            }

            // Toggle filters label
            const filterToggleBtn = document.getElementById('filterToggleBtn');
            const filtersCollapse = document.getElementById('filtersCollapse');
            const LABEL_SHOW = @json(__('app.admin.students.filters.show_filters'));
            const LABEL_HIDE = @json(__('app.admin.students.filters.hide_filters'));
            filtersCollapse.addEventListener('shown.bs.collapse',  () => filterToggleBtn.textContent = LABEL_HIDE);
            filtersCollapse.addEventListener('hidden.bs.collapse', () => filterToggleBtn.textContent = LABEL_SHOW);
        });
    </script>
@endsection
