@php
    $idSuf = ($mode ?? 'form');
@endphp
<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label">{{ __('app.admin.students.form.name') }}</label>
        <input type="text" name="name" class="form-control" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">{{ __('app.admin.students.form.email') }}</label>
        <input type="email" name="email" class="form-control">
    </div>

    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.student_id') }}</label>
        <input type="text" name="student_id" class="form-control">
    </div>
    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.username') }}</label>
        <input type="text" name="username" class="form-control">
    </div>
    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.school') }}</label>
        <select name="school_id" class="form-select">
            <option value="">{{ __('app.admin.students.form.select_school') }}</option>
            @foreach($schools as $s)
                <option value="{{ $s->id }}">{{ $s->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.grade') }}</label>
        <input type="text" name="grade" class="form-control">
    </div>
    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.level') }}</label>
        <input type="text" name="level" class="form-control">
    </div>
    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.section') }}</label>
        <input type="text" name="section" class="form-control">
    </div>

    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.gender') }}</label>
        <input type="text" name="gender" class="form-control" placeholder="{{ __('app.admin.students.form.gender_placeholder') }}">
    </div>
    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.nationality') }}</label>
        <input type="text" name="nationality" class="form-control">
    </div>
    <div class="col-md-4">
        <label class="form-label">{{ __('app.admin.students.form.language') }}</label>
        <select name="preferred_language" class="form-select">
            <option value="en">EN</option>
            <option value="ar">AR</option>
        </select>
    </div>

    <div class="col-md-6">
        <label class="form-label">{{ __('app.admin.students.form.password') }}</label>
        <input type="password" name="password" class="form-control" @if($mode==='create') placeholder="{{ __('app.admin.students.form.password_hint_create') }}" @else placeholder="{{ __('app.admin.students.form.password_hint_update') }}" @endif>
    </div>
    <div class="col-md-6">
        <label class="form-label">{{ __('app.admin.students.form.password_confirmation') }}</label>
        <input type="password" name="password_confirmation" class="form-control" placeholder="{{ __('app.admin.students.form.password_confirmation_hint') }}">
    </div>
</div>
