@extends('layouts.app')

@section('content')
    @php
        // Map the English band value from the report to a translatable key
        $bandRaw = $report['band'] ?? null;
        $bandKey = match($bandRaw) {
          'Below grade' => 'below',
          'Above grade' => 'above',
          'At grade'    => 'at',
          default       => null,
        };
        $bandLabel = $bandKey ? __('app.band.'.$bandKey) : ($bandRaw ?? '-');
    @endphp

    <div class="row justify-content-center">
        <div class="col-12 col-lg-10">
            <div class="card shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h1 class="h5 mb-0">{{ __('app.results.title') }} #{{ $attempt->id }}</h1>
                        <a href="{{ route('dashboard') }}" class="btn btn-outline-secondary btn-sm">&larr; {{ __('app.results.back') }}</a>
                    </div>

                    {{-- Top stats --}}
                    <div class="row g-3">
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1">{{ __('app.results.band') }}</div>
                                <div class="fs-4">{{ $bandLabel }}</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1">{{ __('app.results.recommended_level') }}</div>
                                <div class="fs-4">{{ $report['recommended_level'] ?? '-' }}</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1">{{ __('app.results.se') }}</div>
                                <div class="fs-4">{{ isset($report['se']) ? number_format($report['se'],3) : '-' }}</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1">{{ __('app.results.theta') }}</div>
                                <div class="fs-4">{{ isset($report['theta']) ? number_format($report['theta'],3) : '-' }}</div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="border rounded p-3 mt-2 d-flex justify-content-between align-items-center">
                                <div class="text-muted small">{{ __('app.results.score') }}</div>
                                <div class="fs-5">{{ $report['correct'] ?? 0 }} / {{ $report['total'] ?? $attempt->max_items }}</div>
                            </div>
                        </div>
                    </div>

                    {{-- Difficulty over time chart --}}
                    <div class="mt-4">
                        <h2 class="h6 mb-2">{{ __('app.results.difficulty_over_time') }}</h2>
                        <div class="border rounded p-3">
                            <canvas id="difficultyChart" height="120"></canvas>
                            <div class="small text-muted mt-2 d-flex gap-3">
                                <span><span class="badge" style="background:#dc3545;">&nbsp;</span> {{ __('app.results.wrong') }}</span>
                                <span><span class="badge" style="background:#198754;">&nbsp;</span> {{ __('app.results.correct') }}</span>
                                <span><span class="badge" style="background:#0d6efd;">&nbsp;</span> {{ __('app.results.difficulty_level') }}</span>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
    <script>
        (() => {
            const series = @json($series ?? []);
            if (!series.length) return;

            const labels = series.map(p => p.x);
            const yVals  = series.map(p => p.y);
            const pointColors  = series.map(p => p.correct ? 'rgba(25,135,84,1)' : 'rgba(220,53,69,1)');
            const pointBorders = pointColors;

            const ctx = document.getElementById('difficultyChart').getContext('2d');
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels,
                    datasets: [{
                        label: @json(__('app.results.difficulty_level')),
                        data: yVals,
                        borderColor: '#0d6efd',
                        backgroundColor: 'rgba(13,110,253,0.1)',
                        tension: 0.3,
                        pointRadius: 4,
                        pointHoverRadius: 6,
                        pointBackgroundColor: pointColors,
                        pointBorderColor: pointBorders,
                        fill: false,
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: {
                            title: { display: true, text: @json(__('app.results.question_number')) },
                            ticks: { precision: 0 },
                            grid: { display: false }
                        },
                        y: {
                            min: 1, max: 9, ticks: { stepSize: 1 },
                            title: { display: true, text: @json(__('app.results.difficulty_axis')) }
                        }
                    },
                    plugins: {
                        legend: { display: true },
                        tooltip: {
                            callbacks: {
                                label: (ctx) => {
                                    const i = ctx.dataIndex;
                                    const p = series[i];
                                    const status = p.correct ? @json(__('app.results.correct')) : @json(__('app.results.wrong'));
                                    const bStr = (p.b !== null && p.b !== undefined) ? `, b=${Number(p.b).toFixed(2)}` : '';
                                    return `${status} — L${p.y}${bStr}`;
                                }
                            }
                        }
                    }
                }
            });
        })();
    </script>
@endsection
