@extends('layouts.app')

@section('content')
    <div class="row justify-content-center">
        <div class="col-12 col-md-8 col-xl-6">
            <div class="card shadow-sm">
                <div class="card-body text-center py-5">
                    <div class="display-6 mb-3">✅</div>
                    <h1 class="h4 mb-2">{{ __('app.student.exams.submitted.title') }}</h1>
                    <p class="text-muted mb-4">
                        {{ __('app.student.exams.submitted.body') }}
                    </p>

                    {{-- Optional receipt-style summary (no scores) --}}
                    <div class="text-start d-inline-block border rounded p-3 bg-light mb-4" style="min-width:300px;">
                        <div class="small text-muted mb-2">{{ __('app.student.exams.submitted.summary') }}</div>
                        <div><strong>{{ __('app.student.exams.submitted.fields.exam') }}:</strong> {{ $attempt->exam?->title ?? '—' }}</div>
                        <div><strong>{{ __('app.student.exams.submitted.fields.subject') }}:</strong> {{ $attempt->exam?->subject?->name ?? '—' }}</div>
                        <div><strong>{{ __('app.student.exams.submitted.fields.date') }}:</strong> {{ $attempt->exam?->exam_date?->format('Y-m-d') ?? '—' }}</div>
                        <div><strong>{{ __('app.student.exams.submitted.fields.questions') }}:</strong> {{ (int)$attempt->max_items }}</div>
                        <div><strong>{{ __('app.student.exams.submitted.fields.attempt_id') }}:</strong> #{{ $attempt->id }}</div>
                        <div><strong>{{ __('app.student.exams.submitted.fields.time') }}:</strong>
                            {{ $attempt->started_at?->format('Y-m-d H:i') ?? $attempt->created_at->format('Y-m-d H:i') }}
                            → {{ $attempt->finished_at?->format('Y-m-d H:i') ?? '—' }}
                        </div>
                    </div>

                    <div class="d-grid gap-2 d-sm-flex justify-content-sm-center">
                        <a href="{{ route('dashboard') }}" class="btn btn-primary">
                            {{ __('app.student.exams.submitted.back') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
