@extends('layouts.app')

@section('content')
    <div class="row justify-content-center">
        <div class="col-12 col-md-7 col-lg-5">
            <div class="card shadow-sm">
                <div class="card-body p-4">
                    <h1 class="h4 mb-2">{{ __('app.login.title') }}</h1>
                    <p class="text-muted mb-4">{{ __('app.login.subtitle') }}</p>

                    @if ($errors->any())
                        <div class="alert alert-danger" role="alert">
                            @foreach ($errors->all() as $e)
                                <div>{{ $e }}</div>
                            @endforeach
                        </div>
                    @endif

                    <form method="POST" action="{{ route('login.post') }}" novalidate>
                        @csrf
                        <div class="mb-3">
                            <label for="login" class="form-label">{{ __('app.login.login') }}</label>
                            <input type="text" class="form-control @error('login') is-invalid @enderror"
                                   id="login" name="login" value="{{ old('login') }}" required autocomplete="username">
                            @error('login')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label">{{ __('app.login.password') }}</label>
                            <input type="password" class="form-control" id="password" name="password"
                                   required autocomplete="current-password">
                        </div>

                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="1" id="remember" name="remember">
                                <label class="form-check-label" for="remember">{{ __('app.login.remember') }}</label>
                            </div>
                        </div>

                        <button class="btn btn-success w-100" type="submit">{{ __('app.login.submit') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
