@extends('layouts.app')

@section('content')
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">

            {{-- Header + Quick action --}}
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0">{{ __('app.dashboard.title') }}</h1>
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#startPracticeModal">
                    {{ __('app.dashboard.start_practice') }}
                </button>
            </div>

            {{-- Active Exams --}}
            @if(isset($activeExams) && $activeExams->count())
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <strong>{{ __('app.student.exams.active_title') }}</strong>
                        <span class="text-muted small">{{ __('app.student.exams.active_hint') }}</span>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table align-middle">
                                <thead>
                                <tr>
                                    <th>{{ __('app.student.exams.table.title') }}</th>
                                    <th>{{ __('app.student.exams.table.subject') }}</th>
                                    <th>{{ __('app.student.exams.table.grade') }}</th>
                                    <th>{{ __('app.student.exams.table.lang') }}</th>
                                    <th>{{ __('app.student.exams.table.date') }}</th>
                                    <th>#Q</th>
                                    <th class="text-end">{{ __('app.student.exams.table.action') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($activeExams as $exam)
                                    @php $att = ($examAttempts ?? collect())->get($exam->id); @endphp
                                    <tr>
                                        <td>{{ $exam->title }}</td>
                                        <td>{{ $exam->subject?->name ?? '—' }}</td>
                                        <td>{{ $exam->grade ?? '—' }}</td>
                                        <td>{{ strtoupper($exam->question_language) }}</td>
                                        <td>{{ $exam->exam_date?->format('Y-m-d') ?? '—' }}</td>
                                        <td>{{ $exam->num_questions }}</td>
                                        <td class="text-end">
                                            @if($att)
                                                @if($att->finished_at)
                                                    <a class="btn btn-sm btn-outline-secondary" href="{{ route('exams.attempts.submitted', $att->id) }}">
                                                        {{ __('app.student.exams.submitted_status') }}
                                                    </a>
                                                @else
                                                    <a class="btn btn-sm btn-primary" href="{{ route('exams.attempts.show', $att->id) }}">
                                                        {{ __('app.student.exams.resume') }}
                                                    </a>
                                                @endif
                                            @else
                                                <form method="POST" action="{{ route('student.exams.join', $exam->id) }}" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-primary">
                                                        {{ __('app.student.exams.join') }}
                                                    </button>
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @else
                <div class="alert alert-info">{{ __('app.dashboard.no_active_exams') }}</div>
            @endif

            {{-- Practice Attempts --}}
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <strong>{{ __('app.student.practice.title') }}</strong>
                </div>
                <div class="card-body">
                    @if(isset($attempts) && $attempts->count())
                        <div class="table-responsive">
                            <table class="table align-middle">
                                <thead>
                                <tr>
                                    <th>{{ __('app.student.practice.table.started') }}</th>
                                    <th>{{ __('app.student.practice.table.subject') }}</th>
                                    <th class="text-center">{{ __('app.student.practice.table.progress') }}</th>
                                    <th class="text-center">{{ __('app.student.practice.table.status') }}</th>
                                    <th class="text-end">{{ __('app.student.practice.table.action') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($attempts as $a)
                                    <tr>
                                        <td>{{ $a->started_at?->format('Y-m-d H:i') ?? $a->created_at->format('Y-m-d H:i') }}</td>
                                        <td>{{ $a->subject?->name ?? '—' }}</td>
                                        <td class="text-center">
                                            {{ (int)($a->total_items ?? 0) }} / {{ (int)$a->max_items }}
                                        </td>
                                        <td class="text-center">
                                            @if($a->finished_at)
                                                <span class="badge text-bg-success">{{ __('app.student.practice.finished') }}</span>
                                            @else
                                                <span class="badge text-bg-secondary">{{ __('app.student.practice.in_progress') }}</span>
                                            @endif
                                        </td>
                                        <td class="text-end">
                                            @if($a->finished_at)
                                                <a class="btn btn-sm btn-outline-success" href="{{ route('attempts.results', $a->id) }}">
                                                    {{ __('app.student.practice.view_result') }}
                                                </a>
                                            @else
                                                <a class="btn btn-sm btn-primary" href="{{ route('attempts.show', $a->id) }}">
                                                    {{ __('app.student.practice.resume') }}
                                                </a>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>

                        @if(method_exists($attempts, 'links'))
                            <div class="mt-3">
                                {{ $attempts->onEachSide(1)->links() }}
                            </div>
                        @endif
                    @else
                        <div class="text-muted">{{ __('app.student.practice.empty') }}</div>
                    @endif
                </div>
            </div>

        </div>
    </div>

    {{-- Start Practice Modal --}}
    <div class="modal fade" id="startPracticeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form method="POST" action="{{ route('attempts.start') }}">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('app.dashboard.start_practice') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('app.common.close') }}"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">{{ __('app.dashboard.select_subject') }}</label>
                                <select name="subject_id" class="form-select" required>
                                    @foreach(($subjects ?? []) as $s)
                                        <option value="{{ $s->id }}">{{ $s->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">{{ __('app.dashboard.num_questions') }}</label>
                                <select name="max_items" class="form-select" required>
                                    @foreach([15,30,45,60] as $n)
                                        <option value="{{ $n }}">{{ $n }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">{{ __('app.dashboard.student_summary') }}</label>
                                <div class="form-control-plaintext small text-muted">
                                    {{ auth()->user()->name }}<br>
                                    {{ __('app.profile.grade') }}: {{ auth()->user()->grade ?? '—' }}<br>
                                    {{ __('app.profile.level') }}: {{ auth()->user()->level ?? '—' }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('app.common.cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('app.dashboard.start_quiz') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
