<!doctype html>
<html lang="{{ $appLocale }}" dir="{{ $appDir }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tasheeh-CAT</title>

    {{-- Bootstrap (RTL when Arabic) --}}
    @if ($appDir === 'rtl')
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    @else
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    @endif
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-white bg-white border-bottom">
    <div class="container">
        <a class="navbar-brand fw-semibold" href="{{ route('dashboard') }}">Tasheeh-CAT</a>

        <div class="ms-auto">
            <div class="btn-group" role="group" aria-label="Language Switch">
                <a class="btn btn-outline-secondary btn-sm @if($appLocale==='en') active @endif"
                   href="{{ route('locale.switch','en') }}">@lang('app.footer.switch_to_en')</a>
                <a class="btn btn-outline-secondary btn-sm @if($appLocale==='ar') active @endif"
                   href="{{ route('locale.switch','ar') }}">@lang('app.footer.switch_to_ar')</a>

                @auth
                    @if(auth()->user()->role === 'admin')
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-dark btn-sm me-2">Admin</a>
                    @endif
                @endauth

            </div>
        </div>

    </div>
</nav>

<main class="container py-4">
    @yield('content')
</main>

<footer class="border-top bg-white">
    <div class="container py-3 text-muted small d-flex flex-wrap justify-content-between align-items-center">
        <div class="d-flex align-items-center">
            <span class="me-2">@lang('app.footer.language'):</span>
            <a class="link-primary mx-1" href="{{ route('locale.switch','en') }}">@lang('app.footer.switch_to_en')</a> |
            <a class="link-primary mx-1" href="{{ route('locale.switch','ar') }}">@lang('app.footer.switch_to_ar')</a>
        </div>

        @auth
            <form method="POST" action="{{ route('logout') }}" class="m-0">
                @csrf
                <button type="submit" class="btn btn-outline-danger btn-sm">
                    {{ __('app.dashboard.logout') }}
                </button>
            </form>
        @endauth
    </div>
</footer>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
