<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\LocaleController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\QuizController;
use App\Http\Controllers\StudentExamController;
use App\Http\Controllers\QuizAttemptController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\SchoolController;
use App\Http\Controllers\Admin\StudentController;
use App\Http\Controllers\Admin\QuestionController;
use App\Http\Controllers\Admin\ExamController;
use Illuminate\Support\Facades\Route;

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])
        ->middleware('guest','throttle:6,1')->name('login.post'); // 6 attempts / minute

});



Route::get('/locale/{locale}', [LocaleController::class, 'switch'])->name('locale.switch');
Route::post('/logout', [AuthController::class, 'logout'])
    ->middleware('auth')->name('logout');

// Protect your app pages
Route::middleware('auth')->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');


    Route::post('/attempts/start', [QuizAttemptController::class, 'start'])->name('attempts.start');
    Route::get('/attempts/{attempt}', [QuizAttemptController::class, 'show'])->name('attempts.show');
    Route::get('/attempts/{attempt}/results',  [QuizAttemptController::class, 'results'])->name('attempts.results'); // view results

    Route::post('/exams/{exam}/join', [StudentExamController::class, 'join'])
        ->name('student.exams.join');

    Route::get('/quiz/{attempt}', [QuizController::class, 'show'])
        ->name('quiz.show');

    // AJAX endpoints
    Route::get('/attempts/{attempt}/next',   [QuizAttemptController::class, 'next'])->name('attempts.next');
    Route::post('/attempts/{attempt}/answer',[QuizAttemptController::class, 'answer'])->name('attempts.answer');
    Route::post('/attempts/{attempt}/finish',[QuizAttemptController::class, 'finish'])->name('attempts.finish');


    // Exam attempt pages (same UI, different finish & no results)
    Route::get('/exams/attempts/{attempt}', [QuizAttemptController::class, 'showExam'])
        ->name('exams.attempts.show');           // quiz page (exam mode)
    Route::post('/exams/attempts/{attempt}/finish', [QuizAttemptController::class, 'finishExam'])
        ->name('exams.attempts.finish');         // finish without returning report
    Route::get('/exams/attempts/{attempt}/submitted', [QuizAttemptController::class, 'submitted'])
        ->name('exams.attempts.submitted');      // "submitted" confirmation (no report)


});

Route::middleware(['auth','is_admin'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::get('/', [AdminController::class, 'index'])->name('dashboard');

        // Schools management (placeholder index)
        Route::resource('schools', SchoolController::class)
            ->only(['index','show','store','update','destroy']);

        // Students management (list; filtered by school_id via query string)
        Route::resource('students', StudentController::class)
            ->only(['index','show','store','update','destroy']);

        Route::resource('exams', ExamController::class)
            ->only(['index','show','store','update','destroy']);

        Route::resource('questions', QuestionController::class)
            ->only(['index','show','store','update','destroy']);
        Route::post('questions/import', [QuestionController::class, 'import'])->name('questions.import');


    });

