<?php $idSuf = ($mode ?? 'form'); ?>
<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.title')); ?></label>
        <input type="text" name="title" class="form-control" required>
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.subject')); ?></label>
        <select name="subject_id" class="form-select" required>
            <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.language')); ?></label>
        <select name="question_language" class="form-select" required>
            <option value="en">EN</option>
            <option value="ar">AR</option>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.grade')); ?></label>
        <input type="text" name="grade" class="form-control" placeholder="e.g. 5">
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.year')); ?></label>
        <input type="number" name="year" class="form-control" min="2000" max="2100" placeholder="2025">
    </div>

    <div class="col-md-6">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.school')); ?></label>
        <select name="school_id" class="form-select" required>
            <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($sc->id); ?>"><?php echo e($sc->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-4">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.date')); ?></label>
        <input type="date" name="exam_date" class="form-control">
    </div>

    <div class="col-md-4">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.type')); ?></label>
        <input type="text" name="type" class="form-control" placeholder="Midterm / Final">
    </div>

    <div class="col-md-4">
        <label class="form-label"><?php echo e(__('app.admin.exams.form.num_questions')); ?></label>
        <select name="num_questions" class="form-select" required>
            <?php $__currentLoopData = [15,30,45,60]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($n); ?>"><?php echo e($n); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-12">
        <div class="form-check">
            <input type="hidden" name="is_active" value="0">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active_e_<?php echo e($idSuf); ?>" value="1" checked>
            <label class="form-check-label" for="is_active_e_<?php echo e($idSuf); ?>"><?php echo e(__('app.admin.exams.form.active')); ?></label>
        </div>
    </div>
</div>
<?php /**PATH E:\wamp64\www\cat\resources\views/admin/exams/partials/form.blade.php ENDPATH**/ ?>