<?php $__env->startSection('content'); ?>
    <?php
        // Map the English band value from the report to a translatable key
        $bandRaw = $report['band'] ?? null;
        $bandKey = match($bandRaw) {
          'Below grade' => 'below',
          'Above grade' => 'above',
          'At grade'    => 'at',
          default       => null,
        };
        $bandLabel = $bandKey ? __('app.band.'.$bandKey) : ($bandRaw ?? '-');
    ?>

    <div class="row justify-content-center">
        <div class="col-12 col-lg-10">
            <div class="card shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h1 class="h5 mb-0"><?php echo e(__('app.results.title')); ?> #<?php echo e($attempt->id); ?></h1>
                        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-outline-secondary btn-sm">&larr; <?php echo e(__('app.results.back')); ?></a>
                    </div>

                    
                    <div class="row g-3">
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1"><?php echo e(__('app.results.band')); ?></div>
                                <div class="fs-4"><?php echo e($bandLabel); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1"><?php echo e(__('app.results.recommended_level')); ?></div>
                                <div class="fs-4"><?php echo e($report['recommended_level'] ?? '-'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1"><?php echo e(__('app.results.se')); ?></div>
                                <div class="fs-4"><?php echo e(isset($report['se']) ? number_format($report['se'],3) : '-'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-3 h-100 text-center">
                                <div class="text-muted small mb-1"><?php echo e(__('app.results.theta')); ?></div>
                                <div class="fs-4"><?php echo e(isset($report['theta']) ? number_format($report['theta'],3) : '-'); ?></div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="border rounded p-3 mt-2 d-flex justify-content-between align-items-center">
                                <div class="text-muted small"><?php echo e(__('app.results.score')); ?></div>
                                <div class="fs-5"><?php echo e($report['correct'] ?? 0); ?> / <?php echo e($report['total'] ?? $attempt->max_items); ?></div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="mt-4">
                        <h2 class="h6 mb-2"><?php echo e(__('app.results.difficulty_over_time')); ?></h2>
                        <div class="border rounded p-3">
                            <canvas id="difficultyChart" height="120"></canvas>
                            <div class="small text-muted mt-2 d-flex gap-3">
                                <span><span class="badge" style="background:#dc3545;">&nbsp;</span> <?php echo e(__('app.results.wrong')); ?></span>
                                <span><span class="badge" style="background:#198754;">&nbsp;</span> <?php echo e(__('app.results.correct')); ?></span>
                                <span><span class="badge" style="background:#0d6efd;">&nbsp;</span> <?php echo e(__('app.results.difficulty_level')); ?></span>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
    <script>
        (() => {
            const series = <?php echo json_encode($series ?? [], 15, 512) ?>;
            if (!series.length) return;

            const labels = series.map(p => p.x);
            const yVals  = series.map(p => p.y);
            const pointColors  = series.map(p => p.correct ? 'rgba(25,135,84,1)' : 'rgba(220,53,69,1)');
            const pointBorders = pointColors;

            const ctx = document.getElementById('difficultyChart').getContext('2d');
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels,
                    datasets: [{
                        label: <?php echo json_encode(__('app.results.difficulty_level'), 15, 512) ?>,
                        data: yVals,
                        borderColor: '#0d6efd',
                        backgroundColor: 'rgba(13,110,253,0.1)',
                        tension: 0.3,
                        pointRadius: 4,
                        pointHoverRadius: 6,
                        pointBackgroundColor: pointColors,
                        pointBorderColor: pointBorders,
                        fill: false,
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: {
                            title: { display: true, text: <?php echo json_encode(__('app.results.question_number'), 15, 512) ?> },
                            ticks: { precision: 0 },
                            grid: { display: false }
                        },
                        y: {
                            min: 1, max: 9, ticks: { stepSize: 1 },
                            title: { display: true, text: <?php echo json_encode(__('app.results.difficulty_axis'), 15, 512) ?> }
                        }
                    },
                    plugins: {
                        legend: { display: true },
                        tooltip: {
                            callbacks: {
                                label: (ctx) => {
                                    const i = ctx.dataIndex;
                                    const p = series[i];
                                    const status = p.correct ? <?php echo json_encode(__('app.results.correct'), 15, 512) ?> : <?php echo json_encode(__('app.results.wrong'), 15, 512) ?>;
                                    const bStr = (p.b !== null && p.b !== undefined) ? `, b=${Number(p.b).toFixed(2)}` : '';
                                    return `${status} — L${p.y}${bStr}`;
                                }
                            }
                        }
                    }
                }
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wamp64\www\cat\resources\views/attempts/results.blade.php ENDPATH**/ ?>