<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">

            
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0"><?php echo e(__('app.dashboard.title')); ?></h1>
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#startPracticeModal">
                    <?php echo e(__('app.dashboard.start_practice')); ?>

                </button>
            </div>

            
            <?php if(isset($activeExams) && $activeExams->count()): ?>
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <strong><?php echo e(__('app.student.exams.active_title')); ?></strong>
                        <span class="text-muted small"><?php echo e(__('app.student.exams.active_hint')); ?></span>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table align-middle">
                                <thead>
                                <tr>
                                    <th><?php echo e(__('app.student.exams.table.title')); ?></th>
                                    <th><?php echo e(__('app.student.exams.table.subject')); ?></th>
                                    <th><?php echo e(__('app.student.exams.table.grade')); ?></th>
                                    <th><?php echo e(__('app.student.exams.table.lang')); ?></th>
                                    <th><?php echo e(__('app.student.exams.table.date')); ?></th>
                                    <th>#Q</th>
                                    <th class="text-end"><?php echo e(__('app.student.exams.table.action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $activeExams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $att = ($examAttempts ?? collect())->get($exam->id); ?>
                                    <tr>
                                        <td><?php echo e($exam->title); ?></td>
                                        <td><?php echo e($exam->subject?->name ?? '—'); ?></td>
                                        <td><?php echo e($exam->grade ?? '—'); ?></td>
                                        <td><?php echo e(strtoupper($exam->question_language)); ?></td>
                                        <td><?php echo e($exam->exam_date?->format('Y-m-d') ?? '—'); ?></td>
                                        <td><?php echo e($exam->num_questions); ?></td>
                                        <td class="text-end">
                                            <?php if($att): ?>
                                                <?php if($att->finished_at): ?>
                                                    <a class="btn btn-sm btn-outline-secondary" href="<?php echo e(route('exams.attempts.submitted', $att->id)); ?>">
                                                        <?php echo e(__('app.student.exams.submitted_status')); ?>

                                                    </a>
                                                <?php else: ?>
                                                    <a class="btn btn-sm btn-primary" href="<?php echo e(route('exams.attempts.show', $att->id)); ?>">
                                                        <?php echo e(__('app.student.exams.resume')); ?>

                                                    </a>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <form method="POST" action="<?php echo e(route('student.exams.join', $exam->id)); ?>" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-sm btn-primary">
                                                        <?php echo e(__('app.student.exams.join')); ?>

                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="alert alert-info"><?php echo e(__('app.dashboard.no_active_exams')); ?></div>
            <?php endif; ?>

            
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <strong><?php echo e(__('app.student.practice.title')); ?></strong>
                </div>
                <div class="card-body">
                    <?php if(isset($attempts) && $attempts->count()): ?>
                        <div class="table-responsive">
                            <table class="table align-middle">
                                <thead>
                                <tr>
                                    <th><?php echo e(__('app.student.practice.table.started')); ?></th>
                                    <th><?php echo e(__('app.student.practice.table.subject')); ?></th>
                                    <th class="text-center"><?php echo e(__('app.student.practice.table.progress')); ?></th>
                                    <th class="text-center"><?php echo e(__('app.student.practice.table.status')); ?></th>
                                    <th class="text-end"><?php echo e(__('app.student.practice.table.action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $attempts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($a->started_at?->format('Y-m-d H:i') ?? $a->created_at->format('Y-m-d H:i')); ?></td>
                                        <td><?php echo e($a->subject?->name ?? '—'); ?></td>
                                        <td class="text-center">
                                            <?php echo e((int)($a->total_items ?? 0)); ?> / <?php echo e((int)$a->max_items); ?>

                                        </td>
                                        <td class="text-center">
                                            <?php if($a->finished_at): ?>
                                                <span class="badge text-bg-success"><?php echo e(__('app.student.practice.finished')); ?></span>
                                            <?php else: ?>
                                                <span class="badge text-bg-secondary"><?php echo e(__('app.student.practice.in_progress')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-end">
                                            <?php if($a->finished_at): ?>
                                                <a class="btn btn-sm btn-outline-success" href="<?php echo e(route('attempts.results', $a->id)); ?>">
                                                    <?php echo e(__('app.student.practice.view_result')); ?>

                                                </a>
                                            <?php else: ?>
                                                <a class="btn btn-sm btn-primary" href="<?php echo e(route('attempts.show', $a->id)); ?>">
                                                    <?php echo e(__('app.student.practice.resume')); ?>

                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <?php if(method_exists($attempts, 'links')): ?>
                            <div class="mt-3">
                                <?php echo e($attempts->onEachSide(1)->links()); ?>

                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="text-muted"><?php echo e(__('app.student.practice.empty')); ?></div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>

    
    <div class="modal fade" id="startPracticeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('attempts.start')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('app.dashboard.start_practice')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('app.common.close')); ?>"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label"><?php echo e(__('app.dashboard.select_subject')); ?></label>
                                <select name="subject_id" class="form-select" required>
                                    <?php $__currentLoopData = ($subjects ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label"><?php echo e(__('app.dashboard.num_questions')); ?></label>
                                <select name="max_items" class="form-select" required>
                                    <?php $__currentLoopData = [15,30,45,60]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($n); ?>"><?php echo e($n); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label"><?php echo e(__('app.dashboard.student_summary')); ?></label>
                                <div class="form-control-plaintext small text-muted">
                                    <?php echo e(auth()->user()->name); ?><br>
                                    <?php echo e(__('app.profile.grade')); ?>: <?php echo e(auth()->user()->grade ?? '—'); ?><br>
                                    <?php echo e(__('app.profile.level')); ?>: <?php echo e(auth()->user()->level ?? '—'); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('app.common.cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('app.dashboard.start_quiz')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wamp64\www\cat\resources\views/dashboard.blade.php ENDPATH**/ ?>