<?php $__env->startSection('content'); ?>
    <?php
        $hasFilters = ($filters['q'] ?? '') !== '' ||
                      ($filters['subject_id'] ?? '') !== '' ||
                      ($filters['school_id'] ?? '') !== '' ||
                      ($filters['grade'] ?? '') !== '' ||
                      ($filters['lang'] ?? '') !== '' ||
                      ($filters['year'] ?? '') !== '' ||
                      ($filters['active'] ?? '') !== '';
    ?>

    <div class="row justify-content-center">
        <div class="col-12 col-xl-11">

            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0"><?php echo e(__('app.admin.exams.title')); ?></h1>
                <div class="d-flex flex-wrap gap-2">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary btn-sm">← <?php echo e(__('app.admin.exams.back')); ?></a>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalCreate">
                        <?php echo e(__('app.admin.exams.actions.add_new')); ?>

                    </button>
                    <button id="filterToggleBtn" class="btn btn-outline-primary btn-sm"
                            data-bs-toggle="collapse" data-bs-target="#filtersCollapse" aria-expanded="<?php echo e($hasFilters ? 'true' : 'false'); ?>">
                        <?php echo e($hasFilters ? __('app.admin.exams.filters.hide_filters') : __('app.admin.exams.filters.show_filters')); ?>

                    </button>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger"><?php echo e($errors->first()); ?></div>
            <?php endif; ?>
            <?php if(session('status')): ?>
                <div class="alert alert-success"><?php echo e(session('status')); ?></div>
            <?php endif; ?>

            <div class="collapse <?php echo e($hasFilters ? 'show' : ''); ?>" id="filtersCollapse">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-white fw-semibold"><?php echo e(__('app.admin.exams.filters.title')); ?></div>
                    <div class="card-body">
                        <form method="GET" action="<?php echo e(route('admin.exams.index')); ?>" class="row g-2 align-items-end">
                            <div class="col-12 col-md-3">
                                <label class="form-label"><?php echo e(__('app.admin.exams.filters.title_label')); ?></label>
                                <input type="text" name="q" class="form-control" value="<?php echo e($filters['q'] ?? ''); ?>" placeholder="<?php echo e(__('app.admin.exams.filters.title_label')); ?>">
                            </div>
                            <div class="col-6 col-md-2">
                                <label class="form-label"><?php echo e(__('app.admin.exams.filters.subject')); ?></label>
                                <select name="subject_id" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.exams.filters.all')); ?></option>
                                    <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($s->id); ?>" <?php if(($filters['subject_id'] ?? '') == $s->id): echo 'selected'; endif; ?>><?php echo e($s->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-6 col-md-2">
                                <label class="form-label"><?php echo e(__('app.admin.exams.filters.school')); ?></label>
                                <select name="school_id" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.exams.filters.all')); ?></option>
                                    <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sc->id); ?>" <?php if(($filters['school_id'] ?? '') == $sc->id): echo 'selected'; endif; ?>><?php echo e($sc->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-6 col-md-1">
                                <label class="form-label"><?php echo e(__('app.admin.exams.filters.grade')); ?></label>
                                <input type="text" name="grade" class="form-control" value="<?php echo e($filters['grade'] ?? ''); ?>">
                            </div>
                            <div class="col-6 col-md-1">
                                <label class="form-label"><?php echo e(__('app.admin.exams.filters.lang')); ?></label>
                                <select name="lang" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.exams.filters.all')); ?></option>
                                    <option value="en" <?php if(($filters['lang'] ?? '')==='en'): echo 'selected'; endif; ?>>EN</option>
                                    <option value="ar" <?php if(($filters['lang'] ?? '')==='ar'): echo 'selected'; endif; ?>>AR</option>
                                </select>
                            </div>
                            <div class="col-6 col-md-1">
                                <label class="form-label"><?php echo e(__('app.admin.exams.filters.year')); ?></label>
                                <select name="year" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.exams.filters.all')); ?></option>
                                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($y); ?>" <?php if(($filters['year'] ?? '')==$y): echo 'selected'; endif; ?>><?php echo e($y); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-6 col-md-2">
                                <label class="form-label"><?php echo e(__('app.admin.exams.filters.active')); ?></label>
                                <select name="active" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.exams.filters.all')); ?></option>
                                    <option value="1" <?php if(($filters['active'] ?? '')==='1'): echo 'selected'; endif; ?>><?php echo e(__('app.common.yes')); ?></option>
                                    <option value="0" <?php if(($filters['active'] ?? '')==='0'): echo 'selected'; endif; ?>><?php echo e(__('app.common.no')); ?></option>
                                </select>
                            </div>
                            <div class="col-12 d-flex gap-2">
                                <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.exams.filters.filter')); ?></button>
                                <a href="<?php echo e(route('admin.exams.index')); ?>" class="btn btn-outline-secondary"><?php echo e(__('app.admin.exams.filters.reset')); ?></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th style="width:70px;"><?php echo e(__('app.admin.exams.table.id')); ?></th>
                                <th><?php echo e(__('app.admin.exams.table.title')); ?></th>
                                <th style="width:160px;"><?php echo e(__('app.admin.exams.table.subject')); ?></th>
                                <th style="width:180px;"><?php echo e(__('app.admin.exams.table.school')); ?></th>
                                <th style="width:80px;"><?php echo e(__('app.admin.exams.table.grade')); ?></th>
                                <th style="width:80px;"><?php echo e(__('app.admin.exams.table.lang')); ?></th>
                                <th style="width:80px;"><?php echo e(__('app.admin.exams.table.year')); ?></th>
                                <th style="width:120px;"><?php echo e(__('app.admin.exams.table.date')); ?></th>
                                <th style="width:120px;"><?php echo e(__('app.admin.exams.table.type')); ?></th>
                                <th style="width:70px;">#Q</th>
                                <th style="width:90px;"><?php echo e(__('app.admin.exams.table.active')); ?></th>
                                <th style="width:110px;" class="text-end"><?php echo e(__('app.admin.exams.actions.actions')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>#<?php echo e($e->id); ?></td>
                                    <td><?php echo e($e->title); ?></td>
                                    <td><?php echo e($e->subject?->name ?? '—'); ?></td>
                                    <td><?php echo e($e->school?->name ?? '—'); ?></td>
                                    <td><?php echo e($e->grade ?? '—'); ?></td>
                                    <td><?php echo e(strtoupper($e->question_language)); ?></td>
                                    <td><?php echo e($e->year ?? '—'); ?></td>
                                    <td><?php echo e($e->exam_date?->format('Y-m-d') ?? '—'); ?></td>
                                    <td><?php echo e($e->type ?? '—'); ?></td>
                                    <td><?php echo e($e->num_questions); ?></td>
                                    <td>
                                        <?php if($e->is_active): ?>
                                            <span class="badge text-bg-success"><?php echo e(__('app.common.yes')); ?></span>
                                        <?php else: ?>
                                            <span class="badge text-bg-secondary"><?php echo e(__('app.common.no')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end">
                                        <button class="btn btn-sm btn-outline-primary p-1 js-edit me-1"
                                                data-id="<?php echo e($e->id); ?>"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalEdit"
                                                data-bs-toggle1="tooltip" title="<?php echo e(__('app.admin.exams.actions.edit')); ?>"
                                                aria-label="<?php echo e(__('app.admin.exams.actions.edit')); ?>">
                                            <i class="bi bi-pencil-square"></i><span class="visually-hidden"><?php echo e(__('app.admin.exams.actions.edit')); ?></span>
                                        </button>
                                        <form action="<?php echo e(route('admin.exams.destroy', $e->id)); ?>" method="POST" class="d-inline js-delete">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger p-1"
                                                    data-bs-toggle="tooltip" title="<?php echo e(__('app.admin.exams.actions.delete')); ?>"
                                                    aria-label="<?php echo e(__('app.admin.exams.actions.delete')); ?>">
                                                <i class="bi bi-trash"></i><span class="visually-hidden"><?php echo e(__('app.admin.exams.actions.delete')); ?></span>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="12" class="text-muted"><?php echo e(__('app.admin.exams.empty')); ?></td></tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <?php echo e($exams->onEachSide(1)->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalCreate" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('admin.exams.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('app.admin.exams.actions.add_new')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('app.admin.exams.actions.cancel')); ?>"></button>
                    </div>
                    <div class="modal-body">
                        <?php echo $__env->make('admin.exams.partials.form', ['mode' => 'create', 'subjects' => $subjects, 'schools' => $schools], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('app.admin.exams.actions.cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.exams.actions.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalEdit" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form id="editForm" method="POST" action="#">
                    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('app.admin.exams.actions.edit')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('app.admin.exams.actions.cancel')); ?>"></button>
                    </div>
                    <div class="modal-body">
                        <div id="editLoader" class="text-center my-5">
                            <div class="spinner-border" role="status"></div>
                            <div class="mt-2"><?php echo e(__('app.admin.exams.loader.loading')); ?></div>
                        </div>
                        <div id="editFields" class="d-none">
                            <?php echo $__env->make('admin.exams.partials.form', ['mode' => 'edit', 'subjects' => $subjects, 'schools' => $schools], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('app.admin.exams.actions.cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.exams.actions.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Tooltips
            const triggers = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"],[data-bs-toggle1="tooltip"]'));
            triggers.forEach(el => new bootstrap.Tooltip(el));

            // Delete confirm
            document.querySelectorAll('.js-delete').forEach(form => {
                form.addEventListener('submit', (e) => {
                    if (!confirm(<?php echo json_encode(__('app.admin.exams.confirm_delete'), 15, 512) ?>)) e.preventDefault();
                });
            });

            // Edit loader + fetch
            const editForm   = document.getElementById('editForm');
            const editLoader = document.getElementById('editLoader');
            const editFields = document.getElementById('editFields');

            document.querySelectorAll('.js-edit').forEach(btn => {
                btn.addEventListener('click', async () => {
                    const id = btn.dataset.id;
                    editLoader.classList.remove('d-none');
                    editFields.classList.add('d-none');

                    editForm.action = <?php echo json_encode(route('admin.exams.update', ':id'), 512) ?>.replace(':id', id);

                    try {
                        const res = await fetch(<?php echo json_encode(route('admin.exams.show', ':id'), 512) ?>.replace(':id', id), { headers: { 'Accept':'application/json' }});
                        const data = await res.json();
                        fillExamForm(editFields, data);
                        editLoader.classList.add('d-none');
                        editFields.classList.remove('d-none');
                    } catch (e) {
                        alert(<?php echo json_encode(__('app.admin.exams.loader.failed'), 15, 512) ?>);
                    }
                });
            });

            function fillExamForm(container, data) {
                container.querySelector('[name="title"]').value              = data.title ?? '';
                container.querySelector('[name="subject_id"]').value         = data.subject_id ?? '';
                container.querySelector('[name="question_language"]').value  = data.question_language ?? 'en';
                container.querySelector('[name="grade"]').value              = data.grade ?? '';
                container.querySelector('[name="year"]').value               = data.year ?? '';
                container.querySelector('[name="school_id"]').value          = data.school_id ?? '';
                container.querySelector('[name="exam_date"]').value          = data.exam_date ?? '';
                container.querySelector('[name="type"]').value               = data.type ?? '';
                container.querySelector('[name="num_questions"]').value      = data.num_questions ?? 15;
                container.querySelector('[name="is_active"]').checked        = !!data.is_active;
            }

            // Toggle filters label
            const filterToggleBtn = document.getElementById('filterToggleBtn');
            const filtersCollapse = document.getElementById('filtersCollapse');
            const LABEL_SHOW = <?php echo json_encode(__('app.admin.exams.filters.show_filters'), 15, 512) ?>;
            const LABEL_HIDE = <?php echo json_encode(__('app.admin.exams.filters.hide_filters'), 15, 512) ?>;
            filtersCollapse.addEventListener('shown.bs.collapse',  () => filterToggleBtn.textContent = LABEL_HIDE);
            filtersCollapse.addEventListener('hidden.bs.collapse', () => filterToggleBtn.textContent = LABEL_SHOW);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wamp64\www\cat\resources\views/admin/exams/index.blade.php ENDPATH**/ ?>