<!doctype html>
<html lang="<?php echo e($appLocale); ?>" dir="<?php echo e($appDir); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tasheeh-CAT</title>

    
    <?php if($appDir === 'rtl'): ?>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <?php else: ?>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <?php endif; ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-white bg-white border-bottom">
    <div class="container">
        <a class="navbar-brand fw-semibold" href="<?php echo e(route('dashboard')); ?>">Tasheeh-CAT</a>

        <div class="ms-auto">
            <div class="btn-group" role="group" aria-label="Language Switch">
                <a class="btn btn-outline-secondary btn-sm <?php if($appLocale==='en'): ?> active <?php endif; ?>"
                   href="<?php echo e(route('locale.switch','en')); ?>"><?php echo app('translator')->get('app.footer.switch_to_en'); ?></a>
                <a class="btn btn-outline-secondary btn-sm <?php if($appLocale==='ar'): ?> active <?php endif; ?>"
                   href="<?php echo e(route('locale.switch','ar')); ?>"><?php echo app('translator')->get('app.footer.switch_to_ar'); ?></a>

                <?php if(auth()->guard()->check()): ?>
                    <?php if(auth()->user()->role === 'admin'): ?>
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-dark btn-sm me-2">Admin</a>
                    <?php endif; ?>
                <?php endif; ?>

            </div>
        </div>

    </div>
</nav>

<main class="container py-4">
    <?php echo $__env->yieldContent('content'); ?>
</main>

<footer class="border-top bg-white">
    <div class="container py-3 text-muted small d-flex flex-wrap justify-content-between align-items-center">
        <div class="d-flex align-items-center">
            <span class="me-2"><?php echo app('translator')->get('app.footer.language'); ?>:</span>
            <a class="link-primary mx-1" href="<?php echo e(route('locale.switch','en')); ?>"><?php echo app('translator')->get('app.footer.switch_to_en'); ?></a> |
            <a class="link-primary mx-1" href="<?php echo e(route('locale.switch','ar')); ?>"><?php echo app('translator')->get('app.footer.switch_to_ar'); ?></a>
        </div>

        <?php if(auth()->guard()->check()): ?>
            <form method="POST" action="<?php echo e(route('logout')); ?>" class="m-0">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-outline-danger btn-sm">
                    <?php echo e(__('app.dashboard.logout')); ?>

                </button>
            </form>
        <?php endif; ?>
    </div>
</footer>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH E:\wamp64\www\cat\resources\views/layouts/app.blade.php ENDPATH**/ ?>