
<?php
    $subjects = $subjects ?? \App\Models\Subject::orderBy('name')->get(['id','name']);
    $levels   = $levels   ?? range(1,9);
?>

<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label"><?php echo e(__('app.admin.questions.form.subject')); ?></label>
        <select name="subject_id" class="form-select" required>
            <option value=""><?php echo e(__('app.admin.questions.filters.all')); ?></option>
            <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.questions.form.grade')); ?></label>
        <input type="text" name="grade" class="form-control" placeholder="e.g. 5">
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.questions.form.level')); ?></label>
        <select name="level" class="form-select" required>
            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lvl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($lvl); ?>">L<?php echo e($lvl); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.questions.form.language')); ?></label>
        <select name="question_language" class="form-select" required>
            <option value="en">EN</option>
            <option value="ar">AR</option>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label"><?php echo e(__('app.admin.questions.form.b')); ?></label>
        <input type="number" step="0.01" name="b" class="form-control" placeholder="e.g. 0.0">
    </div>

    <div class="col-md-3 d-flex align-items-end">
        <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" checked>
            <label class="form-check-label" for="is_active"><?php echo e(__('app.admin.questions.form.active')); ?></label>
        </div>
    </div>

    <div class="col-12">
        <label class="form-label"><?php echo e(__('app.admin.questions.form.stem_html')); ?></label>
        <textarea name="stem_html" class="form-control" rows="5" required></textarea>
    </div>

    <div class="col-12">
        <div class="row g-3">
            <?php $__currentLoopData = ['A','B','C','D']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $L): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-md-6">
                    <div class="border rounded p-3 h-100">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <strong><?php echo e(__('app.admin.questions.form.option')); ?> <?php echo e($L); ?></strong>
                            <div class="d-flex align-items-center gap-2">
                                <label class="small text-muted m-0"><?php echo e(__('app.admin.questions.form.weight')); ?></label>
                                <input type="number" step="0.01" min="0" max="1" name="options[<?php echo e($L); ?>][weight]" class="form-control form-control-sm" style="width:90px" value="<?php echo e($L==='A' ? 1 : 0); ?>">
                            </div>
                        </div>
                        <textarea name="options[<?php echo e($L); ?>][text_html]" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php /**PATH E:\wamp64\www\cat\resources\views/admin/questions/partials/form.blade.php ENDPATH**/ ?>