<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <h1 class="h5 m-0"><?php echo e(__('app.admin.dashboard.title')); ?></h1>
                <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-outline-secondary btn-sm">← <?php echo e(__('app.admin.dashboard.student_area')); ?></a>
            </div>

            
            <div class="row g-3 mb-3">
                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1"><?php echo e(__('app.admin.dashboard.cards.students')); ?></div>
                                <div class="fs-3 fw-semibold"><?php echo e($studentsCount); ?></div>
                            </div>
                            <span class="text-secondary fs-2">👩‍🎓</span>
                        </div>
                        <a href="#" class="stretched-link" aria-label="<?php echo e(__('app.admin.dashboard.cards.students')); ?>"></a>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1"><?php echo e(__('app.admin.dashboard.cards.schools')); ?></div>
                                <div class="fs-3 fw-semibold"><?php echo e($schoolsCount); ?></div>
                            </div>
                            <span class="text-secondary fs-2">🏫</span>
                        </div>
                        <a href="<?php echo e(route('admin.schools.index')); ?>" class="stretched-link" aria-label="<?php echo e(__('app.admin.dashboard.cards.schools')); ?>"></a>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1"><?php echo e(__('app.admin.dashboard.cards.exams')); ?></div>
                                <div class="fs-3 fw-semibold"><?php echo e($examsCount); ?></div>
                            </div>
                            <span class="text-secondary fs-2">🧪</span>
                        </div>
                        <a href="<?php echo e(route('admin.exams.index')); ?>" class="stretched-link" aria-label="<?php echo e(__('app.admin.dashboard.cards.exams')); ?>"></a>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1"><?php echo e(__('app.admin.dashboard.cards.attempts')); ?></div>
                                <div class="fs-3 fw-semibold"><?php echo e($attemptsCount); ?></div>
                            </div>
                            <span class="text-secondary fs-2">✅</span>
                        </div>
                        <a href="#" class="stretched-link" aria-label="<?php echo e(__('app.admin.dashboard.cards.attempts')); ?>"></a>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-xl-3">
                    <div class="card shadow-sm h-100 position-relative">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small mb-1"><?php echo e(__('app.admin.dashboard.cards.questions')); ?></div>
                                <div class="fs-3 fw-semibold"><?php echo e($questionsCount); ?></div>
                            </div>
                            <span class="text-secondary fs-2">❓</span>
                        </div>
                        <a href="<?php echo e(route('admin.questions.index')); ?>" class="stretched-link" aria-label="<?php echo e(__('app.admin.dashboard.cards.questions')); ?>"></a>
                    </div>
                </div>
            </div>

            
            <div class="card shadow-sm mb-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h2 class="h6 m-0"><?php echo e(__('app.admin.dashboard.chart_title')); ?></h2>
                    </div>
                    <canvas id="attemptsChart" height="120"></canvas>
                </div>
            </div>

            
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h2 class="h6 m-0"><?php echo e(__('app.admin.dashboard.latest_schools')); ?></h2>
                        <a class="btn btn-sm btn-outline-primary" href="<?php echo e(route('admin.schools.index')); ?>"><?php echo e(__('app.admin.dashboard.show_all')); ?></a>
                    </div>

                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th><?php echo e(__('app.admin.dashboard.schools_table.id')); ?></th>
                                <th><?php echo e(__('app.admin.dashboard.schools_table.name')); ?></th>
                                <th><?php echo e(__('app.admin.dashboard.schools_table.code')); ?></th>
                                <th><?php echo e(__('app.admin.dashboard.schools_table.city')); ?></th>
                                <th><?php echo e(__('app.admin.dashboard.schools_table.country')); ?></th>
                                <th><?php echo e(__('app.admin.dashboard.schools_table.created')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestSchools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>#<?php echo e($s->id); ?></td>
                                    <td><?php echo e($s->name); ?></td>
                                    <td><?php echo e($s->code ?? '—'); ?></td>
                                    <td><?php echo e($s->city ?? '—'); ?></td>
                                    <td><?php echo e($s->country ?? '—'); ?></td>
                                    <td><?php echo e($s->created_at?->format('Y-m-d')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="6" class="text-muted"><?php echo e(__('app.admin.schools.empty')); ?></td></tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>

    
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
    <script>
        (() => {
            const labels = <?php echo json_encode($labels, 15, 512) ?>;
            const counts = <?php echo json_encode($counts, 15, 512) ?>;

            const ctx = document.getElementById('attemptsChart').getContext('2d');
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels,
                    datasets: [{
                        label: <?php echo json_encode(__('app.admin.dashboard.cards.attempts'), 15, 512) ?>,
                        data: counts,
                        backgroundColor: 'rgba(13,110,253,0.3)',
                        borderColor: '#0d6efd',
                        borderWidth: 1,
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: { grid: { display: false } },
                        y: { beginAtZero: true, ticks: { precision: 0 } }
                    },
                    plugins: { legend: { display: false } }
                }
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wamp64\www\cat\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>