<?php $__env->startSection('content'); ?>
    <?php
        $hasFilters = ($filters['name'] ?? '') !== '' || ($filters['code'] ?? '') !== '' || ($filters['city'] ?? '') !== '';
    ?>

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0"><?php echo e(__('app.admin.schools.title')); ?></h1>
                <div class="d-flex flex-wrap gap-2">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary btn-sm">← <?php echo e(__('app.admin.schools.back')); ?></a>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalCreate">
                        <?php echo e(__('app.admin.schools.actions.add_new')); ?>

                    </button>
                    <button id="filterToggleBtn" class="btn btn-outline-primary btn-sm"
                            data-bs-toggle="collapse" data-bs-target="#filtersCollapse" aria-expanded="<?php echo e($hasFilters ? 'true' : 'false'); ?>">
                        <?php echo e($hasFilters ? __('app.admin.schools.filters.hide_filters') : __('app.admin.schools.filters.show_filters')); ?>

                    </button>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger"><?php echo e($errors->first()); ?></div>
            <?php endif; ?>
            <?php if(session('status')): ?>
                <div class="alert alert-success"><?php echo e(session('status')); ?></div>
            <?php endif; ?>

            
            <div class="collapse <?php echo e($hasFilters ? 'show' : ''); ?>" id="filtersCollapse">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-white fw-semibold"><?php echo e(__('app.admin.schools.filters.title')); ?></div>
                    <div class="card-body">
                        <form method="GET" action="<?php echo e(route('admin.schools.index')); ?>" class="row g-2 align-items-end">
                            <div class="col-12 col-md-4">
                                <label class="form-label"><?php echo e(__('app.admin.schools.filters.name')); ?></label>
                                <input type="text" name="name" class="form-control" value="<?php echo e($filters['name'] ?? ''); ?>" placeholder="<?php echo e(__('app.admin.schools.filters.name')); ?>">
                            </div>
                            <div class="col-6 col-md-4">
                                <label class="form-label"><?php echo e(__('app.admin.schools.filters.code')); ?></label>
                                <input type="text" name="code" class="form-control" value="<?php echo e($filters['code'] ?? ''); ?>" placeholder="<?php echo e(__('app.admin.schools.filters.code')); ?>">
                            </div>
                            <div class="col-6 col-md-4">
                                <label class="form-label"><?php echo e(__('app.admin.schools.filters.city')); ?></label>
                                <input type="text" name="city" class="form-control" value="<?php echo e($filters['city'] ?? ''); ?>" placeholder="<?php echo e(__('app.admin.schools.filters.city')); ?>">
                            </div>
                            <div class="col-12 d-flex gap-2">
                                <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.schools.filters.filter')); ?></button>
                                <a href="<?php echo e(route('admin.schools.index')); ?>" class="btn btn-outline-secondary"><?php echo e(__('app.admin.schools.filters.reset')); ?></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th style="width:80px;"><?php echo e(__('app.admin.schools.table.id')); ?></th>
                                <th><?php echo e(__('app.admin.schools.table.name')); ?></th>
                                <th style="width:140px;"><?php echo e(__('app.admin.schools.table.code')); ?></th>
                                <th style="width:180px;"><?php echo e(__('app.admin.schools.table.city')); ?></th>
                                <th style="width:180px;"><?php echo e(__('app.admin.schools.table.country')); ?></th>
                                <th style="width:120px;"><?php echo e(__('app.admin.schools.table.students')); ?></th>
                                <th style="width:120px;"><?php echo e(__('app.admin.schools.table.active')); ?></th>
                                <th style="width:220px;" class="text-end"><?php echo e(__('app.admin.schools.actions.actions')); ?></th>

                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>#<?php echo e($s->id); ?></td>
                                    <td><?php echo e($s->name); ?></td>
                                    <td><?php echo e($s->code ?? '—'); ?></td>
                                    <td><?php echo e($s->city ?? '—'); ?></td>
                                    <td><?php echo e($s->country ?? '—'); ?></td>
                                    <td class="text-center">
                                        <a href="<?php echo e(route('admin.students.index', ['school_id' => $s->id])); ?>" class="btn btn-link btn-sm p-0">
                                            <?php echo e($s->students_count ?? 0); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <?php if($s->is_active): ?>
                                            <span class="badge text-bg-success"><?php echo e(__('app.common.yes')); ?></span>
                                        <?php else: ?>
                                            <span class="badge text-bg-secondary"><?php echo e(__('app.common.no')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end">
                                        <a class="btn btn-sm btn-outline-dark me-1" href="<?php echo e(route('admin.students.index', ['school_id' => $s->id])); ?>">
                                            <?php echo e(__('app.admin.schools.actions.show_students')); ?>

                                        </a>

                                        <button class="btn btn-sm btn-outline-primary p-1 js-edit me-1"
                                                data-id="<?php echo e($s->id); ?>"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalEdit"
                                                data-bs-toggle1="tooltip" title="<?php echo e(__('app.admin.schools.actions.edit')); ?>"
                                                aria-label="<?php echo e(__('app.admin.schools.actions.edit')); ?>">
                                            <i class="bi bi-pencil-square"></i><span class="visually-hidden"><?php echo e(__('app.admin.schools.actions.edit')); ?></span>
                                        </button>

                                        <form action="<?php echo e(route('admin.schools.destroy', $s->id)); ?>" method="POST" class="d-inline js-delete">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger p-1"
                                                    data-bs-toggle="tooltip" title="<?php echo e(__('app.admin.schools.actions.delete')); ?>"
                                                    aria-label="<?php echo e(__('app.admin.schools.actions.delete')); ?>">
                                                <i class="bi bi-trash"></i><span class="visually-hidden"><?php echo e(__('app.admin.schools.actions.delete')); ?></span>
                                            </button>
                                        </form>
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="7" class="text-muted"><?php echo e(__('app.admin.schools.empty')); ?></td></tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <?php echo e($schools->onEachSide(1)->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalCreate" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('admin.schools.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('app.admin.schools.actions.add_new')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('app.admin.schools.actions.cancel')); ?>"></button>
                    </div>
                    <div class="modal-body">
                        <?php echo $__env->make('admin.schools.partials.form', ['mode' => 'create'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('app.admin.schools.actions.cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.schools.actions.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalEdit" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form id="editForm" method="POST" action="#">
                    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('app.admin.schools.actions.edit')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('app.admin.schools.actions.cancel')); ?>"></button>
                    </div>
                    <div class="modal-body">
                        <div id="editLoader" class="text-center my-5">
                            <div class="spinner-border" role="status"></div>
                            <div class="mt-2"><?php echo e(__('app.admin.schools.loader.loading')); ?></div>
                        </div>
                        <div id="editFields" class="d-none">
                            <?php echo $__env->make('admin.schools.partials.form', ['mode' => 'edit'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('app.admin.schools.actions.cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.schools.actions.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Delete confirm
            document.querySelectorAll('.js-delete').forEach(form => {
                form.addEventListener('submit', (e) => {
                    if (!confirm(<?php echo json_encode(__('app.admin.schools.confirm_delete'), 15, 512) ?>)) e.preventDefault();
                });
            });

            // Edit loader/fill
            const editForm   = document.getElementById('editForm');
            const editLoader = document.getElementById('editLoader');
            const editFields = document.getElementById('editFields');

            document.querySelectorAll('.js-edit').forEach(btn => {
                btn.addEventListener('click', async () => {
                    const id = btn.dataset.id;
                    editLoader.classList.remove('d-none');
                    editFields.classList.add('d-none');

                    editForm.action = <?php echo json_encode(route('admin.schools.update', ':id'), 512) ?>.replace(':id', id);

                    try {
                        const res = await fetch(<?php echo json_encode(route('admin.schools.show', ':id'), 512) ?>.replace(':id', id), { headers: { 'Accept':'application/json' }});
                        const data = await res.json();
                        fillSchoolForm(editFields, data);
                        editLoader.classList.add('d-none');
                        editFields.classList.remove('d-none');
                    } catch (e) {
                        alert(<?php echo json_encode(__('app.admin.schools.loader.failed'), 15, 512) ?>);
                    }
                });
            });

            function fillSchoolForm(container, data) {
                container.querySelector('[name="name"]').value       = data.name ?? '';
                container.querySelector('[name="short_name"]').value = data.short_name ?? '';
                container.querySelector('[name="code"]').value       = data.code ?? '';
                container.querySelector('[name="city"]').value       = data.city ?? '';
                container.querySelector('[name="country"]').value    = data.country ?? '';
                container.querySelector('[name="is_active"]').checked= !!data.is_active;
            }

            // Toggle filters label
            const filterToggleBtn = document.getElementById('filterToggleBtn');
            const filtersCollapse = document.getElementById('filtersCollapse');
            const LABEL_SHOW = <?php echo json_encode(__('app.admin.schools.filters.show_filters'), 15, 512) ?>;
            const LABEL_HIDE = <?php echo json_encode(__('app.admin.schools.filters.hide_filters'), 15, 512) ?>;
            filtersCollapse.addEventListener('shown.bs.collapse',  () => filterToggleBtn.textContent = LABEL_HIDE);
            filtersCollapse.addEventListener('hidden.bs.collapse', () => filterToggleBtn.textContent = LABEL_SHOW);
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Initialize Bootstrap tooltips
            const triggers = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"],[data-bs-toggle1="tooltip"]'));
            triggers.forEach(el => new bootstrap.Tooltip(el));
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wamp64\www\cat\resources\views/admin/schools/index.blade.php ENDPATH**/ ?>