<?php $__env->startSection('content'); ?>
    <?php
        $hasFilters = !empty(($filters['q'] ?? '')) ||
                      !empty(($filters['subject_id'] ?? '')) ||
                      strlen((string)($filters['grade'] ?? '')) ||
                      strlen((string)($filters['level'] ?? ''));
    ?>

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
                <h1 class="h5 m-0"><?php echo e(__('app.admin.questions.title')); ?></h1>
                <div class="d-flex flex-wrap gap-2">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary btn-sm">← <?php echo e(__('app.admin.questions.back')); ?></a>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalCreate">
                        <?php echo e(__('app.admin.questions.actions.add_new')); ?>

                    </button>
                    <button id="filterToggleBtn" class="btn btn-outline-primary btn-sm"
                            data-bs-toggle="collapse" data-bs-target="#filtersCollapse" aria-expanded="<?php echo e($hasFilters ? 'true' : 'false'); ?>">
                        <?php echo e($hasFilters ? __('app.admin.questions.filters.hide_filters') : __('app.admin.questions.filters.show_filters')); ?>

                    </button>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger"><?php echo e($errors->first()); ?></div>
            <?php endif; ?>

            <?php if(session('status')): ?>
                <div class="alert alert-success"><?php echo e(session('status')); ?></div>
            <?php endif; ?>

            
            <div class="collapse <?php echo e($hasFilters ? 'show' : ''); ?>" id="filtersCollapse">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <span class="fw-semibold"><?php echo e(__('app.admin.questions.filters.title')); ?></span>

                        
                        <form id="excelImportForm" class="d-flex align-items-center gap-2 m-0" method="POST"
                              action="<?php echo e(route('admin.questions.import')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input id="excelPicker" type="file" name="file" accept=".xlsx,.xls,.csv" class="d-none">
                            <button type="button" id="excelBtn" class="btn btn-outline-success btn-sm">
                                <?php echo e(__('app.admin.questions.import.button')); ?>

                            </button>
                        </form>
                    </div>

                    <div class="card-body">
                        <form method="GET" action="<?php echo e(route('admin.questions.index')); ?>" class="row g-2 align-items-end">
                            <div class="col-12 col-md-4">
                                <label class="form-label"><?php echo e(__('app.admin.questions.filters.search')); ?></label>
                                <input type="text"
                                       name="q"
                                       value="<?php echo e($filters['q'] ?? ''); ?>"
                                       class="form-control"
                                       placeholder="<?php echo e(__('app.admin.questions.filters.search')); ?>">
                            </div>

                            <div class="col-6 col-md-2">
                                <label class="form-label"><?php echo e(__('app.admin.questions.filters.subject')); ?></label>
                                <select name="subject_id" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.questions.filters.all')); ?></option>
                                    <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($s->id); ?>" <?php if(($filters['subject_id'] ?? '') == $s->id): echo 'selected'; endif; ?>><?php echo e($s->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-6 col-md-2">
                                <label class="form-label"><?php echo e(__('app.admin.questions.filters.grade')); ?></label>
                                <select name="grade" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.questions.filters.all')); ?></option>
                                    <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($g); ?>" <?php if(($filters['grade'] ?? '') == $g): echo 'selected'; endif; ?>><?php echo e($g); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-6 col-md-2">
                                <label class="form-label"><?php echo e(__('app.admin.questions.filters.level')); ?></label>
                                <select name="level" class="form-select">
                                    <option value=""><?php echo e(__('app.admin.questions.filters.all')); ?></option>
                                    <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lvl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($lvl); ?>" <?php if(($filters['level'] ?? '') == $lvl): echo 'selected'; endif; ?>><?php echo e($lvl); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-6 col-md-2 d-flex gap-2">
                                <button type="submit" class="btn btn-primary w-100"><?php echo e(__('app.admin.questions.filters.filter')); ?></button>
                                <a href="<?php echo e(route('admin.questions.index')); ?>" class="btn btn-outline-secondary"><?php echo e(__('app.admin.questions.filters.reset')); ?></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle">
                            <thead>
                            <tr>
                                <th style="width:70px;"><?php echo e(__('app.admin.questions.table.id')); ?></th>
                                <th style="width:200px;"><?php echo e(__('app.admin.questions.table.subject')); ?></th>
                                <th style="width:90px;"><?php echo e(__('app.admin.questions.table.grade')); ?></th>
                                <th style="width:90px;"><?php echo e(__('app.admin.questions.table.level')); ?></th>
                                <th style="width:90px;"><?php echo e(__('app.admin.questions.table.lang')); ?></th>
                                <th><?php echo e(__('app.admin.questions.table.question')); ?></th>
                                <th style="width:160px;" class="text-end"><?php echo e(__('app.admin.questions.actions.actions')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $q): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>#<?php echo e($q->id); ?></td>
                                    <td><?php echo e($q->subject?->name ?? $q->subject_id); ?></td>
                                    <td><?php echo e($q->grade ?? '—'); ?></td>
                                    <td><?php echo e($q->level); ?></td>
                                    <td><?php echo e(strtoupper($q->question_language)); ?></td>
                                    <td><div class="q-stem clamp-3"><?php echo $q->stem_html; ?></div></td>
                                    <td class="text-end">
                                        <button class="btn btn-sm btn-outline-primary js-edit" data-id="<?php echo e($q->id); ?>" data-bs-toggle="modal" data-bs-target="#modalEdit">
                                            <?php echo e(__('app.admin.questions.actions.edit')); ?>

                                        </button>
                                        <form action="<?php echo e(route('admin.questions.destroy', $q->id)); ?>" method="POST" class="d-inline js-delete">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <?php echo e(__('app.admin.questions.actions.delete')); ?>

                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="7" class="text-muted"><?php echo e(__('app.admin.questions.empty')); ?></td></tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <?php echo e($questions->onEachSide(1)->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalCreate" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('admin.questions.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('app.admin.questions.actions.add_new')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('app.admin.questions.actions.cancel')); ?>"></button>
                    </div>
                    <div class="modal-body">
                        <?php echo $__env->make('admin.questions.partials.form', ['mode' => 'create'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('app.admin.questions.actions.cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.questions.actions.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalEdit" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form id="editForm" method="POST" action="#">
                    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('app.admin.questions.actions.edit')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('app.admin.questions.actions.cancel')); ?>"></button>
                    </div>
                    <div class="modal-body">
                        <div id="editLoader" class="text-center my-5">
                            <div class="spinner-border" role="status"></div>
                            <div class="mt-2"><?php echo e(__('app.admin.questions.loader.loading')); ?></div>
                        </div>
                        <div id="editFields" class="d-none">
                            <?php echo $__env->make('admin.questions.partials.form', ['mode' => 'edit'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('app.admin.questions.actions.cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('app.admin.questions.actions.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <style>
        .q-stem { max-width:100%; overflow:hidden; }
        .clamp-3 { display:-webkit-box; -webkit-line-clamp:3; -webkit-box-orient:vertical; }
        .q-stem, .q-stem * { font-size:.95rem !important; line-height:1.5; }
    </style>

    
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Delete confirm
            document.querySelectorAll('.js-delete').forEach(form => {
                form.addEventListener('submit', (e) => {
                    if (!confirm(<?php echo json_encode(__('app.admin.questions.confirm_delete'), 15, 512) ?>)) {
                        e.preventDefault();
                    }
                });
            });

            // Edit loader + fetch
            const editForm   = document.getElementById('editForm');
            const editLoader = document.getElementById('editLoader');
            const editFields = document.getElementById('editFields');

            document.querySelectorAll('.js-edit').forEach(btn => {
                btn.addEventListener('click', async () => {
                    const id = btn.dataset.id;
                    // reset UI
                    editLoader.classList.remove('d-none');
                    editFields.classList.add('d-none');
                    // set action
                    editForm.action = <?php echo json_encode(route('admin.questions.update', ':id'), 512) ?>.replace(':id', id);

                    // fetch data
                    try {
                        const res = await fetch(<?php echo json_encode(route('admin.questions.show', ':id'), 512) ?>.replace(':id', id), { headers: { 'Accept':'application/json' }});
                        const data = await res.json();

                        // Fill fields
                        fillQuestionForm(editFields, data);

                        editLoader.classList.add('d-none');
                        editFields.classList.remove('d-none');
                    } catch (e) {
                        console.error(e);
                        alert(<?php echo json_encode(__('app.admin.questions.loader.failed'), 15, 512) ?>);
                    }
                });
            });

            function fillQuestionForm(container, data) {
                container.querySelector('[name="subject_id"]').value = data.subject_id ?? '';
                container.querySelector('[name="grade"]').value       = data.grade ?? '';
                container.querySelector('[name="level"]').value       = data.level ?? '';
                container.querySelector('[name="question_language"]').value = data.question_language ?? 'en';
                container.querySelector('[name="b"]').value           = (data.b ?? '') === null ? '' : data.b;
                container.querySelector('[name="is_active"]').checked = !!data.is_active;
                container.querySelector('[name="stem_html"]').value   = data.stem_html ?? '';

                const byLabel = {};
                (data.options || []).forEach(o => byLabel[o.label] = o);
                ['A','B','C','D'].forEach(L => {
                    const o = byLabel[L] || {};
                    container.querySelector(`[name="options[${L}][text_html]"]`).value = o.text_html ?? '';
                    container.querySelector(`[name="options[${L}][weight]"]`).value    = (o.weight ?? 0);
                });
            }

            // Excel picker auto-submit
            const picker = document.getElementById('excelPicker');
            const btn    = document.getElementById('excelBtn');
            const form   = document.getElementById('excelImportForm');
            if (btn && picker && form) {
                btn.addEventListener('click', () => picker.click());
                picker.addEventListener('change', () => {
                    if (picker.files.length) {
                        btn.disabled = true;
                        btn.textContent = <?php echo json_encode(__('app.admin.questions.import.uploading'), 15, 512) ?>;
                        form.submit();
                    }
                });
            }

            // Toggle button label for filters
            const filterToggleBtn = document.getElementById('filterToggleBtn');
            const filtersCollapse = document.getElementById('filtersCollapse');
            const LABEL_SHOW = <?php echo json_encode(__('app.admin.questions.filters.show_filters'), 15, 512) ?>;
            const LABEL_HIDE = <?php echo json_encode(__('app.admin.questions.filters.hide_filters'), 15, 512) ?>;

            filtersCollapse.addEventListener('shown.bs.collapse', () => { filterToggleBtn.textContent = LABEL_HIDE; });
            filtersCollapse.addEventListener('hidden.bs.collapse', () => { filterToggleBtn.textContent = LABEL_SHOW; });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wamp64\www\cat\resources\views/admin/questions/index.blade.php ENDPATH**/ ?>